/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.map;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.common.accessor.world.level.saveddata.maps.MapItemSavedDataAccessor;
import org.spongepowered.common.bridge.world.storage.MapItemSavedDataBridge;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.map.canvas.SpongeMapByteCanvas;
import org.spongepowered.common.map.canvas.SpongeMapCanvas;
import org.spongepowered.math.vector.Vector2i;

public final class MapInfoData {
    private MapInfoData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(MapItemSavedData.class).create(Keys.MAP_CANVAS).get(mapData -> new SpongeMapByteCanvas(mapData.colors))).set((mapData, mapCanvas) -> {
            ((SpongeMapCanvas)mapCanvas).applyToMapData((MapItemSavedData)mapData);
            ((MapItemSavedDataBridge)mapData).bridge$updateWholeMap();
        })).create(Keys.MAP_LOCATION).get(mapData -> Vector2i.from((int)mapData.x, (int)mapData.z))).set((mapData, vector2i) -> {
            ((MapItemSavedDataBridge)mapData).bridge$setOrigin(vector2i.x(), vector2i.y(), mapData.scale);
            mapData.setDirty();
        })).create(Keys.MAP_LOCKED).get(mapData -> mapData.locked)).set((mapData, locked) -> {
            ((MapItemSavedDataAccessor)mapData).accessor$locked((boolean)locked);
            mapData.setDirty();
        })).create(Keys.MAP_SCALE).get(mapData -> mapData.scale)).set((mapData, scale) -> {
            ((MapItemSavedDataAccessor)mapData).accessor$scale(scale.byteValue());
            ((MapItemSavedDataBridge)mapData).bridge$setOrigin(mapData.x, mapData.z, mapData.scale);
            mapData.setDirty();
        })).create(Keys.MAP_TRACKS_PLAYERS).get(mapData -> ((MapItemSavedDataAccessor)mapData).accessor$trackingPosition())).set((mapData, tracksPlayers) -> {
            ((MapItemSavedDataAccessor)mapData).accessor$trackingPosition((boolean)tracksPlayers);
            mapData.setDirty();
        })).create(Keys.MAP_UNLIMITED_TRACKING).get(mapData -> ((MapItemSavedDataAccessor)mapData).accessor$unlimitedTracking())).set((mapData, unlimitedTracking) -> {
            ((MapItemSavedDataAccessor)mapData).accessor$unlimitedTracking((boolean)unlimitedTracking);
            mapData.setDirty();
        })).create(Keys.MAP_WORLD).get(mapData -> {
            int id = ((MapItemSavedDataBridge)mapData).bridge$getMapId();
            if (mapData.dimension == null) {
                LogManager.getLogger().error("Map with id: {}, uuid: {} has an null world. This will probably cause more errors later/on save", (Object)id, (Object)((MapInfo)mapData).uniqueId());
                return null;
            }
            return (org.spongepowered.api.ResourceKey)mapData.dimension.location();
        })).set((mapData, key) -> {
            ((MapItemSavedDataAccessor)mapData).accessor$dimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registry.DIMENSION_REGISTRY, (ResourceLocation)((ResourceLocation)key)));
            mapData.setDirty();
        })).asMutable(MapItemSavedDataBridge.class).create(Keys.MAP_DECORATIONS).get(MapItemSavedDataBridge::bridge$getDecorations)).set(MapItemSavedDataBridge::bridge$setDecorations);
        registrator.spongeDataStore(org.spongepowered.api.ResourceKey.sponge("map-data"), MapInfo.class, Keys.MAP_DECORATIONS);
    }
}

