/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.data.value.AbstractMutableSpongeValue;
import org.spongepowered.common.util.CopyHelper;

public final class MutableSpongeMapValue<K, V>
extends AbstractMutableSpongeValue<Map<K, V>>
implements MapValue.Mutable<K, V> {
    public MutableSpongeMapValue(Key<? extends MapValue<K, V>> key, Map<K, V> element) {
        super(key, element);
    }

    @Override
    public SpongeKey<? extends MapValue<K, V>, Map<K, V>> key() {
        return super.key();
    }

    @Override
    public int size() {
        return ((Map)this.get()).size();
    }

    @Override
    public boolean containsKey(K key) {
        return ((Map)this.get()).containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return ((Map)this.get()).containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return ((Map)this.get()).keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((Map)this.get()).entrySet();
    }

    @Override
    public Collection<V> values() {
        return ((Map)this.get()).values();
    }

    @Override
    public MapValue.Mutable<K, V> set(Map<K, V> value) {
        super.set(value);
        return this;
    }

    @Override
    public MapValue.Mutable<K, V> put(K key, V value) {
        this.modifyMap(map -> map.put(key, value));
        return this;
    }

    @Override
    public MapValue.Mutable<K, V> putAll(Map<K, V> other) {
        this.modifyMap(map -> map.putAll(other));
        return this;
    }

    @Override
    public MapValue.Mutable<K, V> remove(K key) {
        this.modifyMap(map -> map.remove(key));
        return this;
    }

    @Override
    public MapValue.Mutable<K, V> removeAll(Iterable<K> keys) {
        this.modifyMap(map -> keys.forEach(map::remove));
        return this;
    }

    @Override
    public MapValue.Mutable<K, V> removeAll(Predicate<Map.Entry<K, V>> predicate) {
        this.modifyMap(map -> map.entrySet().removeIf(predicate));
        return this;
    }

    private void modifyMap(Consumer<Map<K, V>> consumer) {
        Map map = (Map)this.get();
        if (map instanceof ImmutableMap) {
            LinkedHashMap mutable = new LinkedHashMap(map);
            consumer.accept(mutable);
            this.set((Map<K, V>)ImmutableMap.copyOf(mutable));
        } else {
            consumer.accept(map);
        }
    }

    @Override
    public MapValue.Mutable<K, V> transform(Function<Map<K, V>, Map<K, V>> function) {
        return this.set(function.apply((Map)this.get()));
    }

    @Override
    public MapValue.Mutable<K, V> copy() {
        return new MutableSpongeMapValue<K, V>(this.key(), CopyHelper.copy((Map)this.get()));
    }

    @Override
    public MapValue.Immutable<K, V> asImmutable() {
        return ((MapValue)((SpongeKey)this.key()).getValueConstructor().getImmutable((Map)this.get())).asImmutable();
    }
}

