/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value;

import io.leangen.geantyref.GenericTypeReflector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.WeightedCollectionValue;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.data.value.CachedBooleanValueConstructor;
import org.spongepowered.common.data.value.CachedEnumValueConstructor;
import org.spongepowered.common.data.value.ImmutableSpongeListValue;
import org.spongepowered.common.data.value.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.ImmutableSpongeSetValue;
import org.spongepowered.common.data.value.ImmutableSpongeValue;
import org.spongepowered.common.data.value.ImmutableSpongeWeightedCollectionValue;
import org.spongepowered.common.data.value.MutableSpongeListValue;
import org.spongepowered.common.data.value.MutableSpongeMapValue;
import org.spongepowered.common.data.value.MutableSpongeSetValue;
import org.spongepowered.common.data.value.MutableSpongeValue;
import org.spongepowered.common.data.value.MutableSpongeWeightedCollectionValue;
import org.spongepowered.common.data.value.SimpleValueConstructor;
import org.spongepowered.common.data.value.ValueConstructor;

public final class ValueConstructorFactory {
    public static <V extends Value<E>, E> ValueConstructor<V, E> getConstructor(SpongeKey<V, E> key) {
        ValueConstructor<Object, Object> valueConstructor;
        Class<?> valueType = GenericTypeReflector.erase(key.valueType());
        if (ListValue.class.isAssignableFrom(valueType)) {
            valueConstructor = new SimpleValueConstructor<Object, Object>(key, (key1, value) -> new MutableSpongeListValue((Key)key1, (List)value), (key1, value) -> new ImmutableSpongeListValue((Key)key1, (List)value));
        } else if (SetValue.class.isAssignableFrom(valueType)) {
            valueConstructor = new SimpleValueConstructor<Object, Object>(key, (key1, value) -> new MutableSpongeSetValue((Key)key1, (Set)value), (key1, value) -> new ImmutableSpongeSetValue((Key)key1, (Set)value));
        } else if (MapValue.class.isAssignableFrom(valueType)) {
            valueConstructor = new SimpleValueConstructor<Object, Object>(key, (key1, value) -> new MutableSpongeMapValue((Key)key1, (Map)value), (key1, value) -> new ImmutableSpongeMapValue((Key)key1, (Map)value));
        } else if (WeightedCollectionValue.class.isAssignableFrom(valueType)) {
            valueConstructor = new SimpleValueConstructor<Object, Object>(key, (key1, value) -> new MutableSpongeWeightedCollectionValue((Key)key1, (WeightedTable)value), (key1, value) -> new ImmutableSpongeWeightedCollectionValue((Key)key1, (WeightedTable)value));
        } else {
            valueConstructor = new SimpleValueConstructor<Object, Object>(key, (key1, value) -> new MutableSpongeValue<Object>((Key)key1, value), (key1, value) -> new ImmutableSpongeValue<Object>((Key)key1, value));
            Class<?> elementType = GenericTypeReflector.erase(key.elementType());
            if (Enum.class.isAssignableFrom(elementType)) {
                valueConstructor = new CachedEnumValueConstructor<Object, Object>(valueConstructor, elementType);
            } else if (elementType == Boolean.class) {
                valueConstructor = new CachedBooleanValueConstructor(valueConstructor);
            }
        }
        return valueConstructor;
    }
}

