/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.golem.Shulker;
import org.spongepowered.api.entity.projectile.Egg;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.ExperienceBottle;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.entity.projectile.Potion;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.entity.projectile.explosive.fireball.DragonFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.SmallFireball;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.entity.projectile.DispenserSourceLogic;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;
import org.spongepowered.common.entity.projectile.ShulkerSourceLogic;
import org.spongepowered.common.entity.projectile.SimpleDispenserLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleEntityLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleItemLaunchLogic;
import org.spongepowered.math.vector.Vector3d;

public final class ProjectileUtil {
    private static final Map<EntityType<? extends Projectile>, ProjectileLogic<?>> projectileLogic = Maps.newHashMap();
    private static final Map<Class<? extends ProjectileSource>, ProjectileSourceLogic<?>> projectileSourceLogic = Maps.newHashMap();

    public static <T extends Projectile> Optional<T> launch(EntityType<T> projectileType, ProjectileSource source, @Nullable Vector3d vel) {
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = logic.launch(source);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.offer(Keys.SHOOTER, source);
        });
        return projectile;
    }

    public static <T extends Projectile, S extends ProjectileSource> Optional<T> launchWithArgs(EntityType<T> projectileType, Class<S> projectileSourceClass, S source, @Nullable Vector3d vel, Object ... args) {
        ProjectileSourceLogic<S> sourceLogic = ProjectileUtil.getSourceLogic(projectileSourceClass);
        if (sourceLogic == null) {
            return Optional.empty();
        }
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = sourceLogic.launch(logic, source, projectileType, args);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.offer(Keys.SHOOTER, source);
        });
        return projectile;
    }

    private static void configureThrowable(ThrowableProjectile entity) {
        double x = entity.getX() - (double)(Mth.cos((float)(entity.getYRot() / 180.0f * (float)Math.PI)) * 0.16f);
        double y = entity.getY() - 0.1;
        double z = entity.getZ() - (double)(Mth.sin((float)(entity.getYRot() / 180.0f * (float)Math.PI)) * 0.16f);
        entity.setPos(x, y, z);
        float f = 0.4f;
        double motionX = -Mth.sin((float)(entity.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(entity.getXRot() / 180.0f * (float)Math.PI)) * 0.4f;
        double motionZ = Mth.cos((float)(entity.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(entity.getXRot() / 180.0f * (float)Math.PI)) * 0.4f;
        double motionY = -Mth.sin((float)(entity.getXRot() / 180.0f * (float)Math.PI)) * 0.4f;
        entity.setDeltaMovement(motionX, motionY, motionZ);
    }

    public static <T extends Projectile> void registerProjectileLogic(Supplier<EntityType<T>> projectileType, ProjectileLogic<T> logic) {
        projectileLogic.put(projectileType.get(), logic);
    }

    public static <T extends ProjectileSource> void registerProjectileSourceLogic(Class<T> projectileSourceClass, ProjectileSourceLogic<T> logic) {
        projectileSourceLogic.put(projectileSourceClass, logic);
    }

    static <T extends ProjectileSource> ProjectileSourceLogic<T> getSourceLogic(Class<T> sourceClass) {
        return projectileSourceLogic.get(sourceClass);
    }

    private static <T extends Projectile> ProjectileLogic<T> getLogic(EntityType<T> projectileType) {
        return projectileLogic.get(projectileType);
    }

    static <P extends Projectile> Optional<P> defaultLaunch(ProjectileSource source, EntityType<P> projectileType, ServerLocation loc) {
        Entity projectile = ((ServerWorld)loc.world()).createEntity(projectileType, loc.position());
        if (projectile instanceof ThrowableProjectile) {
            ProjectileUtil.configureThrowable((ThrowableProjectile)projectile);
        }
        return ProjectileUtil.doLaunch(loc.world(), (Projectile)projectile);
    }

    static <P extends Projectile> Optional<P> doLaunch(World extent, P projectile) {
        if (extent.spawnEntity(projectile)) {
            return Optional.of(projectile);
        }
        return Optional.empty();
    }

    static {
        ProjectileUtil.registerProjectileSourceLogic(Dispenser.class, new DispenserSourceLogic());
        ProjectileUtil.registerProjectileSourceLogic(Shulker.class, new ShulkerSourceLogic());
        ProjectileUtil.registerProjectileLogic(EntityTypes.ARROW, new SimpleItemLaunchLogic<org.spongepowered.api.entity.projectile.arrow.Arrow>(EntityTypes.ARROW, Items.ARROW){

            @Override
            protected Optional<org.spongepowered.api.entity.projectile.arrow.Arrow> createProjectile(LivingEntity source, ServerLocation loc) {
                Arrow arrow = new Arrow(source.level, source);
                arrow.shoot((double)source.getXRot(), (double)source.getYRot(), 0.0, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (org.spongepowered.api.entity.projectile.arrow.Arrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SPECTRAL_ARROW, new SimpleItemLaunchLogic<org.spongepowered.api.entity.projectile.arrow.SpectralArrow>(EntityTypes.SPECTRAL_ARROW, Items.SPECTRAL_ARROW){

            @Override
            protected Optional<org.spongepowered.api.entity.projectile.arrow.SpectralArrow> createProjectile(LivingEntity source, ServerLocation loc) {
                SpectralArrow arrow = new SpectralArrow(source.level, source);
                arrow.shoot((double)source.getXRot(), (double)source.getYRot(), 0.0, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (org.spongepowered.api.entity.projectile.arrow.SpectralArrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EGG, new SimpleItemLaunchLogic<Egg>(EntityTypes.EGG, Items.EGG){

            @Override
            protected Optional<Egg> createProjectile(LivingEntity source, ServerLocation loc) {
                ThrownEgg egg = new ThrownEgg(source.level, source);
                egg.shoot((double)source.getXRot(), (double)source.getYRot(), 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (Egg)egg);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SMALL_FIREBALL, new SimpleItemLaunchLogic<SmallFireball>(EntityTypes.SMALL_FIREBALL, Items.FIRE_CHARGE){

            @Override
            protected Optional<SmallFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3 lookVec = source.getViewVector(1.0f);
                net.minecraft.world.entity.projectile.SmallFireball fireball = new net.minecraft.world.entity.projectile.SmallFireball(source.level, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                fireball.setPos(fireball.getX(), fireball.getY() + (double)source.getEyeHeight(), fireball.getZ());
                return ProjectileUtil.doLaunch(loc.world(), (SmallFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREWORK_ROCKET, new SimpleItemLaunchLogic<FireworkRocket>(EntityTypes.FIREWORK_ROCKET, Items.FIREWORK_ROCKET){

            @Override
            protected Optional<FireworkRocket> createProjectile(LivingEntity source, ServerLocation loc) {
                FireworkRocketEntity firework = new FireworkRocketEntity(source.level, loc.x(), loc.y(), loc.z(), ItemStack.EMPTY);
                return ProjectileUtil.doLaunch(loc.world(), (FireworkRocket)firework);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SNOWBALL, new SimpleItemLaunchLogic<org.spongepowered.api.entity.projectile.Snowball>(EntityTypes.SNOWBALL, Items.SNOWBALL){

            @Override
            protected Optional<org.spongepowered.api.entity.projectile.Snowball> createProjectile(LivingEntity source, ServerLocation loc) {
                Snowball snowball = new Snowball(source.level, source);
                snowball.shoot((double)source.getXRot(), (double)source.getYRot(), 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (org.spongepowered.api.entity.projectile.Snowball)snowball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EXPERIENCE_BOTTLE, new SimpleItemLaunchLogic<ExperienceBottle>(EntityTypes.EXPERIENCE_BOTTLE, Items.EXPERIENCE_BOTTLE){

            @Override
            protected Optional<ExperienceBottle> createProjectile(LivingEntity source, ServerLocation loc) {
                ThrownExperienceBottle expBottle = new ThrownExperienceBottle(source.level, source);
                expBottle.shoot((double)source.getXRot(), (double)source.getYRot(), -20.0, 0.7f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (ExperienceBottle)expBottle);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.ENDER_PEARL, new SimpleItemLaunchLogic<EnderPearl>(EntityTypes.ENDER_PEARL, Items.ENDER_PEARL){

            @Override
            protected Optional<EnderPearl> createProjectile(LivingEntity source, ServerLocation loc) {
                ThrownEnderpearl pearl = new ThrownEnderpearl(source.level, source);
                pearl.shoot((double)source.getXRot(), (double)source.getYRot(), 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (EnderPearl)pearl);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREBALL, new SimpleDispenserLaunchLogic<ExplosiveFireball>(EntityTypes.FIREBALL){

            @Override
            protected Optional<ExplosiveFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3 lookVec = source.getViewVector(1.0f);
                LargeFireball fireball = new LargeFireball(source.level, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0, 1);
                fireball.setPos(fireball.getX(), fireball.getY() + (double)source.getEyeHeight(), fireball.getZ());
                return ProjectileUtil.doLaunch(loc.world(), (ExplosiveFireball)fireball);
            }

            @Override
            public Optional<ExplosiveFireball> createProjectile(ProjectileSource source, EntityType<ExplosiveFireball> projectileType, ServerLocation loc) {
                if (!(source instanceof DispenserBlockEntity)) {
                    return super.createProjectile(source, projectileType, loc);
                }
                DispenserBlockEntity dispenser = (DispenserBlockEntity)source;
                Direction enumfacing = DispenserSourceLogic.getFacing(dispenser);
                ArmorStand thrower = new ArmorStand(dispenser.getLevel(), loc.x() + (double)enumfacing.getStepX(), loc.y() + (double)enumfacing.getStepY(), loc.z() + (double)enumfacing.getStepZ());
                LargeFireball fireball = new LargeFireball(dispenser.getLevel(), (LivingEntity)thrower, 0.0, 0.0, 0.0, 1);
                fireball.xPower = (double)enumfacing.getStepX() * 0.1;
                fireball.yPower = (double)enumfacing.getStepY() * 0.1;
                fireball.zPower = (double)enumfacing.getStepZ() * 0.1;
                return ProjectileUtil.doLaunch(loc.world(), (ExplosiveFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.WITHER_SKULL, new SimpleDispenserLaunchLogic<WitherSkull>(EntityTypes.WITHER_SKULL){

            @Override
            protected Optional<WitherSkull> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3 lookVec = source.getViewVector(1.0f);
                net.minecraft.world.entity.projectile.WitherSkull skull = new net.minecraft.world.entity.projectile.WitherSkull(source.level, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                skull.setPos(skull.getX(), skull.getY() + (double)source.getEyeHeight(), skull.getZ());
                return ProjectileUtil.doLaunch(loc.world(), (WitherSkull)skull);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EYE_OF_ENDER, new SimpleDispenserLaunchLogic(EntityTypes.EYE_OF_ENDER));
        ProjectileUtil.registerProjectileLogic(EntityTypes.FISHING_BOBBER, new SimpleDispenserLaunchLogic<FishingBobber>(EntityTypes.FISHING_BOBBER){

            @Override
            protected Optional<FishingBobber> createProjectile(LivingEntity source, ServerLocation loc) {
                if (source instanceof Player) {
                    FishingHook hook = new FishingHook((Player)source, source.level, 0, 0);
                    hook.setPos(loc.x(), loc.y(), loc.z());
                    return ProjectileUtil.doLaunch(loc.world(), (FishingBobber)hook);
                }
                return super.createProjectile(source, loc);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.POTION, new SimpleItemLaunchLogic<Potion>(EntityTypes.POTION, Items.SPLASH_POTION){

            @Override
            protected Optional<Potion> createProjectile(LivingEntity source, ServerLocation loc) {
                ThrownPotion potion = new ThrownPotion(source.level, source);
                potion.setItem(new ItemStack((ItemLike)Items.SPLASH_POTION, 1));
                potion.shoot((double)source.getXRot(), (double)source.getYRot(), -20.0, 0.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (Potion)potion);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.LLAMA_SPIT, new SimpleEntityLaunchLogic<org.spongepowered.api.entity.projectile.LlamaSpit>(EntityTypes.LLAMA_SPIT){

            @Override
            public Optional<org.spongepowered.api.entity.projectile.LlamaSpit> launch(ProjectileSource source) {
                if (!(source instanceof Llama)) {
                    return Optional.empty();
                }
                return super.launch(source);
            }

            @Override
            public Optional<org.spongepowered.api.entity.projectile.LlamaSpit> createProjectile(ProjectileSource source, EntityType<org.spongepowered.api.entity.projectile.LlamaSpit> projectileType, ServerLocation loc) {
                Llama llama = (Llama)source;
                LlamaSpit llamaSpit = new LlamaSpit(llama.level, (Llama)source);
                Vec3 lookVec = llama.getViewVector(1.0f);
                llamaSpit.shoot(lookVec.x, lookVec.y, lookVec.z, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.world(), (org.spongepowered.api.entity.projectile.LlamaSpit)llamaSpit);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.DRAGON_FIREBALL, new SimpleDispenserLaunchLogic<DragonFireball>(EntityTypes.DRAGON_FIREBALL){

            @Override
            protected Optional<DragonFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3 lookVec = source.getViewVector(1.0f);
                net.minecraft.world.entity.projectile.DragonFireball fireball = new net.minecraft.world.entity.projectile.DragonFireball(source.level, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                fireball.setPos(fireball.getX(), fireball.getY() + (double)source.getEyeHeight(), fireball.getZ());
                return ProjectileUtil.doLaunch(loc.world(), (DragonFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SHULKER_BULLET, new SimpleEntityLaunchLogic(EntityTypes.SHULKER_BULLET));
    }
}

