/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ChunkPipeline
implements BlockPipeline {
    private final @Nullable Supplier<LevelChunk> chunkSupplier;
    private final @Nullable Supplier<ServerLevel> serverWorld;
    private final @Nullable Supplier<LevelChunkSection> sectionSupplier;
    private final boolean wasEmpty;
    private final List<ResultingTransactionBySideEffect> chunkEffects;
    final ChangeBlock transaction;

    public static ChunkPipeline nullReturn(LevelChunk chunk, ServerLevel world) {
        return new ChunkPipeline(chunk, world);
    }

    private ChunkPipeline(LevelChunk chunk, ServerLevel world) {
        WeakReference<LevelChunk> chunkWeakReference = new WeakReference<LevelChunk>(chunk);
        this.chunkSupplier = () -> (LevelChunk)chunkWeakReference.get();
        WeakReference<ServerLevel> serverWorldWeakReference = new WeakReference<ServerLevel>(world);
        this.serverWorld = () -> (ServerLevel)serverWorldWeakReference.get();
        this.sectionSupplier = () -> null;
        this.wasEmpty = true;
        this.chunkEffects = Collections.emptyList();
        this.transaction = null;
    }

    ChunkPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.chunkEffects = builder.effects;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        this.wasEmpty = Objects.requireNonNull(builder.sectionSupplier).get().hasOnlyAir();
        this.transaction = builder.transaction;
    }

    public Supplier<LevelChunk> getChunkSupplier() {
        return this.chunkSupplier;
    }

    public List<ResultingTransactionBySideEffect> getChunkEffects() {
        return this.chunkEffects;
    }

    @Override
    public ServerLevel getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in ChunkPipeline").get();
    }

    @Override
    public LevelChunk getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in ChunkPipeline").get();
    }

    @Override
    public LevelChunkSection getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in ChunkPipeline").get();
    }

    public @Nullable BlockState processChange(PhaseContext<?> context, BlockState currentState, BlockState proposedState, BlockPos pos, int limit) {
        if (this.chunkEffects.isEmpty()) {
            return null;
        }
        ServerLevel serverWorld = this.serverWorld.get();
        int oldOpacity = currentState.getLightBlock((BlockGetter)serverWorld, pos);
        SpongeBlockChangeFlag flag = this.transaction.getBlockChangeFlag();
        @Nullable BlockEntity existing = this.chunkSupplier.get().getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        PipelineCursor formerState = new PipelineCursor(currentState, oldOpacity, pos, existing, null, limit);
        for (ResultingTransactionBySideEffect effect : this.chunkEffects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            try {
                EffectResult result = effect.effect.processSideEffect(this, formerState, proposedState, flag, limit);
                if (result.hasResult) {
                    BlockState blockState = result.resultingState;
                    return blockState;
                }
                if (!formerState.drops.isEmpty() || result.drops.isEmpty()) continue;
                formerState = new PipelineCursor(currentState, oldOpacity, pos, existing, null, result.drops, limit);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    public static final class Builder {
        @Nullable Supplier<ServerLevel> serverWorld;
        @Nullable Supplier<LevelChunk> chunkSupplier;
        @Nullable Supplier<LevelChunkSection> sectionSupplier;
        boolean wasSectionEmpty;
        @MonotonicNonNull ChangeBlock transaction;
        List<ResultingTransactionBySideEffect> effects;

        public Builder kickOff(ChangeBlock transaction) {
            this.transaction = Objects.requireNonNull(transaction, "ChangeBlock transaction cannot be null!");
            return this;
        }

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public Builder chunk(LevelChunk chunk) {
            WeakReference<LevelChunk> worldRef = new WeakReference<LevelChunk>(chunk);
            this.chunkSupplier = () -> {
                LevelChunk chunkRef = (LevelChunk)worldRef.get();
                if (chunkRef == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return chunkRef;
            };
            return this;
        }

        public Builder chunkSection(LevelChunkSection section) {
            WeakReference<LevelChunkSection> worldRef = new WeakReference<LevelChunkSection>(section);
            this.sectionSupplier = () -> {
                LevelChunkSection chunkRef = (LevelChunkSection)worldRef.get();
                if (chunkRef == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return chunkRef;
            };
            this.wasSectionEmpty = section.hasOnlyAir();
            return this;
        }

        public Builder world(ServerLevel world) {
            WeakReference<ServerLevel> worldRef = new WeakReference<ServerLevel>(world);
            this.serverWorld = () -> {
                ServerLevel serverWorld = (ServerLevel)worldRef.get();
                if (serverWorld == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return serverWorld;
            };
            return this;
        }

        public ChunkPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            Objects.requireNonNull(this.transaction, "ChangeBlock transaction must have been recorded!");
            return new ChunkPipeline(this);
        }
    }
}

