/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject;

import com.google.common.base.MoreObjects;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SpongeInjectionPoint
implements AnnotatedElement {
    private final Type source;
    private final Type type;
    private final Annotation[] annotations;

    SpongeInjectionPoint(Type source, Type type, Annotation[] annotations) {
        this.annotations = annotations;
        this.source = source;
        this.type = type;
    }

    public Type getSource() {
        return this.source;
    }

    public Type getType() {
        return this.type;
    }

    public <A extends Annotation> @Nullable A getAnnotation(Class<A> annotationClass) {
        return (A)((Annotation)Arrays.stream(this.annotations).filter(annotationClass::isInstance).findFirst().orElse(null));
    }

    @Override
    public Annotation[] getAnnotations() {
        return Arrays.copyOf(this.annotations, this.annotations.length);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return Arrays.copyOf(this.annotations, this.annotations.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("type", (Object)this.type).add("annotations", (Object)Arrays.toString(this.annotations)).toString();
    }
}

