/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.commands;

import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={CommandSourceStack.class})
public abstract class CommandSourceStackMixin_API
implements CommandCause {
    @Override
    public Cause cause() {
        return ((CommandSourceStackBridge)((Object)this)).bridge$getCause();
    }

    @Override
    public Subject subject() {
        return this.cause().context().get(EventContextKeys.SUBJECT).orElseGet(() -> this.cause().first(Subject.class).orElseGet(Sponge::systemSubject));
    }

    @Override
    public Audience audience() {
        return this.cause().context().get(EventContextKeys.AUDIENCE).orElseGet(() -> this.cause().first(Audience.class).orElseGet(Sponge::systemSubject));
    }

    @Override
    public Optional<ServerLocation> location() {
        Cause cause = this.cause();
        EventContext eventContext = cause.context();
        if (eventContext.containsKey(EventContextKeys.LOCATION)) {
            return eventContext.get(EventContextKeys.LOCATION);
        }
        Optional<ServerLocation> optionalLocation = this.targetBlock().flatMap(LocatableSnapshot::location);
        if (optionalLocation.isPresent()) {
            return optionalLocation;
        }
        return cause.first(Locatable.class).map(Locatable::serverLocation);
    }

    @Override
    public Optional<Vector3d> rotation() {
        Cause cause = this.cause();
        EventContext eventContext = cause.context();
        if (eventContext.containsKey(EventContextKeys.ROTATION)) {
            return eventContext.get(EventContextKeys.ROTATION);
        }
        return cause.first(Entity.class).map(Entity::rotation);
    }

    @Override
    public Optional<BlockSnapshot> targetBlock() {
        return Optional.ofNullable(this.cause().context().get(EventContextKeys.BLOCK_TARGET).orElseGet(() -> this.cause().first(BlockSnapshot.class).orElse(null)));
    }

    @Override
    public void sendMessage(@NonNull Identified identity, @NonNull Component message) {
        this.audience().sendMessage(identity, message);
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message) {
        this.audience().sendMessage(identity, message);
    }
}

