/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.entity;

import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.spongepowered.api.block.entity.MobSpawner;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.level.BaseSpawnerBridge;
import org.spongepowered.common.mixin.api.minecraft.world.level.block.entity.BlockEntityMixin_API;

@Mixin(value={SpawnerBlockEntity.class})
public abstract class SpawnerBlockEntityMixin_API
extends BlockEntityMixin_API
implements MobSpawner {
    @Shadow
    public abstract BaseSpawner shadow$getSpawner();

    @Override
    public void spawnEntityBatchImmediately(boolean force) {
        BaseSpawnerBridge bridge = (BaseSpawnerBridge)this.shadow$getSpawner();
        if (force) {
            short oldMaxNearby = (short)bridge.bridge$getMaxNearbyEntities();
            bridge.bridge$setMaxNearbyEntities(Short.MAX_VALUE);
            bridge.bridge$setSpawnDelay(0);
            if (!this.level.isClientSide) {
                this.shadow$getSpawner().serverTick((ServerLevel)this.level, this.worldPosition);
            }
            bridge.bridge$setMaxNearbyEntities(oldMaxNearby);
        } else {
            bridge.bridge$setSpawnDelay(0);
        }
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.remainingDelay().asImmutable());
        values.add(this.minimumSpawnDelay().asImmutable());
        values.add(this.maximumSpawnDelay().asImmutable());
        values.add(this.spawnCount().asImmutable());
        values.add(this.maximumNearbyEntities().asImmutable());
        values.add(this.requiredPlayerRange().asImmutable());
        values.add(this.spawnRange().asImmutable());
        values.add(this.nextEntityToSpawn().asImmutable());
        values.add(this.possibleEntitiesToSpawn().asImmutable());
        return values;
    }
}

