/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.dimension;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.WorldTypeTemplate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.registry.provider.DimensionEffectProvider;
import org.spongepowered.common.util.SpongeMinecraftDayTime;
import org.spongepowered.common.world.server.SpongeWorldTypeTemplate;

@Mixin(value={DimensionType.class})
@Implements(value={@Interface(iface=WorldType.class, prefix="worldType$", remap=Interface.Remap.NONE)})
public abstract class DimensionTypeMixin_API
implements WorldType {
    @Shadow
    @Final
    private ResourceLocation effectsLocation;
    @Shadow
    @Final
    private float ambientLight;
    @Shadow
    @Final
    private OptionalLong fixedTime;
    private @Nullable Context api$context;

    @Shadow
    public abstract boolean shadow$ultraWarm();

    @Shadow
    public abstract boolean shadow$natural();

    @Shadow
    public abstract double shadow$coordinateScale();

    @Shadow
    public abstract boolean shadow$hasSkyLight();

    @Shadow
    public abstract boolean shadow$hasCeiling();

    @Shadow
    public abstract boolean shadow$piglinSafe();

    @Shadow
    public abstract boolean shadow$bedWorks();

    @Shadow
    public abstract boolean shadow$respawnAnchorWorks();

    @Shadow
    public abstract boolean shadow$hasRaids();

    @Shadow
    public abstract int shadow$logicalHeight();

    @Shadow
    public abstract boolean shadow$createDragonFight();

    @Override
    public Context context() {
        if (this.api$context == null) {
            ResourceLocation key = Objects.requireNonNull(SpongeCommon.server().registryAccess().registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY).getKey((Object)((DimensionType)this)), "DimensionType is not registered: " + this);
            this.api$context = new Context("dimension", key.getPath());
        }
        return this.api$context;
    }

    @Override
    public WorldTypeEffect effect() {
        @Nullable WorldTypeEffect effect = DimensionEffectProvider.INSTANCE.get((ResourceKey)this.effectsLocation);
        if (effect == null) {
            throw new IllegalStateException(String.format("The effect '%s' has not been registered!", this.effectsLocation));
        }
        return effect;
    }

    @Override
    public boolean scorching() {
        return this.shadow$ultraWarm();
    }

    @Intrinsic
    public boolean worldType$natural() {
        return this.shadow$natural();
    }

    @Override
    public double coordinateMultiplier() {
        return this.shadow$coordinateScale();
    }

    @Override
    public boolean hasSkylight() {
        return this.shadow$hasSkyLight();
    }

    @Intrinsic
    public boolean worldType$hasCeiling() {
        return this.shadow$hasCeiling();
    }

    @Override
    public float ambientLighting() {
        return this.ambientLight;
    }

    @Override
    public Optional<MinecraftDayTime> fixedTime() {
        OptionalLong fixedTime = this.fixedTime;
        if (!fixedTime.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new SpongeMinecraftDayTime(fixedTime.getAsLong()));
    }

    @Intrinsic
    public boolean worldType$piglinSafe() {
        return this.shadow$piglinSafe();
    }

    @Override
    public boolean bedsUsable() {
        return this.shadow$bedWorks();
    }

    @Override
    public boolean respawnAnchorsUsable() {
        return this.shadow$respawnAnchorWorks();
    }

    @Override
    public WorldTypeTemplate asTemplate() {
        return new SpongeWorldTypeTemplate((ResourceKey)Objects.requireNonNull(SpongeCommon.server().registryAccess().registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY).getKey((Object)((DimensionType)this)), "Registry type is not registered: " + this), (DimensionType)this);
    }

    @Intrinsic
    public boolean worldType$hasRaids() {
        return this.shadow$hasRaids();
    }

    @Intrinsic
    public int worldType$logicalHeight() {
        return this.shadow$logicalHeight();
    }

    @Intrinsic
    public boolean worldType$createDragonFight() {
        return this.shadow$createDragonFight();
    }
}

