/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.goal.GoalExecutorTypes;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.UnleashEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.bridge.world.entity.ai.goal.GoalSelectorBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.DamageEventUtil;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntityMixin {
    @Shadow
    @Final
    protected GoalSelector goalSelector;
    @Shadow
    @Final
    protected GoalSelector targetSelector;
    @Shadow
    @Nullable
    private LivingEntity target;

    @Shadow
    @Nullable
    public abstract net.minecraft.world.entity.Entity shadow$getLeashHolder();

    @Shadow
    protected abstract void shadow$registerGoals();

    @Shadow
    protected abstract void shadow$maybeDisableShield(Player var1, ItemStack var2, ItemStack var3);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;registerGoals()V"))
    private void impl$registerGoals(Mob this$0) {
        this.impl$setupGoalSelectors();
        this.shadow$registerGoals();
    }

    private void impl$setupGoalSelectors() {
        if (!((GoalSelectorBridge)this.goalSelector).bridge$initialized()) {
            ((GoalSelectorBridge)this.goalSelector).bridge$setOwner((Mob)this);
            ((GoalSelectorBridge)this.goalSelector).bridge$setType(GoalExecutorTypes.NORMAL.get());
            ((GoalSelectorBridge)this.goalSelector).bridge$setInitialized(true);
        }
        if (!((GoalSelectorBridge)this.targetSelector).bridge$initialized()) {
            ((GoalSelectorBridge)this.targetSelector).bridge$setOwner((Mob)this);
            ((GoalSelectorBridge)this.targetSelector).bridge$setType(GoalExecutorTypes.TARGET.get());
            ((GoalSelectorBridge)this.targetSelector).bridge$setInitialized(true);
        }
    }

    @Inject(method={"dropLeash"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Mob;leashHolder:Lnet/minecraft/world/entity/Entity;", opcode=181)}, cancellable=true)
    private void impl$ThrowUnleashEvent(boolean sendPacket, boolean dropLead, CallbackInfo ci) {
        if (this.level.isClientSide) {
            return;
        }
        net.minecraft.world.entity.Entity entity = this.shadow$getLeashHolder();
        CauseStackManager csm = PhaseTracker.getCauseStackManager();
        if (entity == null) {
            csm.pushCause(this);
        } else {
            csm.pushCause(entity);
        }
        UnleashEntityEvent event = SpongeEventFactory.createUnleashEntityEvent(csm.currentCause(), (Living)((Object)this));
        SpongeCommon.post(event);
        csm.popCause();
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetAttackTarget(@Nullable LivingEntity entitylivingbaseIn, CallbackInfo ci) {
        if (this.level.isClientSide || entitylivingbaseIn == null) {
            return;
        }
        if (EntityUtil.isUntargetable((net.minecraft.world.entity.Entity)this, (net.minecraft.world.entity.Entity)entitylivingbaseIn)) {
            this.target = null;
            ci.cancel();
            return;
        }
        if (ShouldFire.SET_A_I_TARGET_EVENT) {
            SetAITargetEvent event = SpongeCommonEventFactory.callSetAttackTargetEvent((Entity)entitylivingbaseIn, (Agent)((Object)this));
            if (event.isCancelled()) {
                ci.cancel();
            } else {
                this.target = event.target().orElse(null);
            }
        }
    }

    @Nullable
    @Overwrite
    public LivingEntity getTarget() {
        if (this.target != null && EntityUtil.isUntargetable((net.minecraft.world.entity.Entity)this, (net.minecraft.world.entity.Entity)this.target)) {
            this.target = null;
        }
        return this.target;
    }

    @Redirect(method={"aiStep()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;canPickUpLoot()Z"))
    private boolean impl$onCanGrief(Mob thisEntity) {
        return thisEntity.canPickUpLoot() && ((GrieferBridge)((Object)this)).bridge$canGrief();
    }

    @Overwrite
    public boolean doHurtTarget(net.minecraft.world.entity.Entity targetEntity) {
        double originalBaseDamage = this.shadow$getAttribute(Attributes.ATTACK_DAMAGE).getValue();
        ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
        float knockbackModifier = (float)this.shadow$getAttribute(Attributes.ATTACK_KNOCKBACK).getValue();
        if (targetEntity instanceof LivingEntity) {
            originalFunctions.addAll(DamageEventUtil.createAttackEnchantmentFunction(this.shadow$getMainHandItem(), ((LivingEntity)targetEntity).getMobType(), 1.0f));
            knockbackModifier += (float)EnchantmentHelper.getKnockbackBonus((LivingEntity)((Mob)this));
        }
        DamageSource damageSource = DamageSource.mobAttack((LivingEntity)((Mob)this));
        PhaseTracker.getCauseStackManager().pushCause(damageSource);
        AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(PhaseTracker.getCauseStackManager().currentCause(), (Entity)targetEntity, originalFunctions, knockbackModifier, originalBaseDamage);
        SpongeCommon.post(event);
        PhaseTracker.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            return false;
        }
        knockbackModifier = event.knockbackModifier();
        boolean attackSucceeded = targetEntity.hurt(damageSource, (float)event.finalOutputDamage());
        if (attackSucceeded) {
            int j;
            if (knockbackModifier > 0.0f && targetEntity instanceof LivingEntity) {
                ((LivingEntity)targetEntity).knockback((double)(knockbackModifier * 0.5f), (double)Mth.sin((float)(this.shadow$getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.shadow$getYRot() * ((float)Math.PI / 180)))));
                this.shadow$setDeltaMovement(this.shadow$getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.getFireAspect((LivingEntity)((Mob)this))) > 0) {
                targetEntity.setSecondsOnFire(j * 4);
            }
            if (targetEntity instanceof Player) {
                Player playerentity = (Player)targetEntity;
                ItemStack mainHandItem = this.shadow$getMainHandItem();
                ItemStack useItem = playerentity.isUsingItem() ? playerentity.getUseItem() : ItemStack.EMPTY;
                this.shadow$maybeDisableShield(playerentity, mainHandItem, useItem);
            }
            this.shadow$doEnchantDamageEffects((LivingEntity)((Mob)this), targetEntity);
            this.shadow$setLastHurtMob(targetEntity);
        }
        return attackSucceeded;
    }

    @Nullable
    @Redirect(method={"checkDespawn()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getNearestPlayer(Lnet/minecraft/world/entity/Entity;D)Lnet/minecraft/world/entity/player/Player;"))
    private Player impl$getClosestPlayerForSpawning(Level world, net.minecraft.world.entity.Entity entityIn, double distance) {
        double bestDistance = -1.0;
        Player result = null;
        for (Player player : world.players()) {
            if (player == null || player.isRemoved() || !((PlayerBridge)player).bridge$affectsSpawning()) continue;
            double playerDistance = player.distanceToSqr(entityIn);
            if (!(distance < 0.0) && !(playerDistance < distance * distance) || bestDistance != -1.0 && !(playerDistance < bestDistance)) continue;
            bestDistance = playerDistance;
            result = player;
        }
        return result;
    }

    @Inject(method={"setLeashedTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetLeashedTo(net.minecraft.world.entity.Entity param0, boolean param1, CallbackInfo ci) {
        if (!this.level.isClientSide) {
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            if (Sponge.eventManager().post(SpongeEventFactory.createLeashEntityEvent(currentCause, (Entity)((Object)this)))) {
                ci.cancel();
            }
        }
    }
}

