/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.decoration;

import java.util.ArrayList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.LivingEntityMixin;
import org.spongepowered.common.util.DamageEventUtil;

@Mixin(value={ArmorStand.class})
public abstract class ArmorStandMixin
extends LivingEntityMixin {
    @Shadow
    protected abstract void shadow$causeDamage(DamageSource var1, float var2);

    private void impl$fireDestroyDamageEvent(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            DamageEventUtil.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.currentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), Math.max(1000.0f, this.shadow$getHealth()));
            if (SpongeCommon.post(event)) {
                cir.setReturnValue((Object)false);
            }
            if (event.finalDamage() < (double)this.shadow$getHealth()) {
                this.shadow$causeDamage(source, (float)event.finalDamage());
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V"))
    private void impl$actuallyKill(ArmorStand target) {
        target.remove(Entity.RemovalReason.KILLED);
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/damagesource/DamageSource;OUT_OF_WORLD:Lnet/minecraft/world/damagesource/DamageSource;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V", ordinal=0)}, cancellable=true)
    private void impl$fireDamageEventOutOfWorld(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.impl$fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;isExplosion()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;causeDamage(Lnet/minecraft/world/damagesource/DamageSource;F)V")}, cancellable=true)
    private void impl$fireDamageEventExplosion(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.impl$fireDestroyDamageEvent(source, cir);
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;causeDamage(Lnet/minecraft/world/damagesource/DamageSource;F)V"))
    private void impl$fireDamageEventDamage(ArmorStand self, DamageSource source, float amount) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            DamageEventUtil.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.currentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), amount);
            if (!SpongeCommon.post(event)) {
                this.shadow$causeDamage(source, (float)event.finalDamage());
            }
        }
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;isCreativePlayer()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;playBrokenSound()V")}, cancellable=true)
    private void impl$fireDamageEventCreativePunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.impl$fireDestroyDamageEvent(source, cir);
    }

    @Inject(method={"hurt"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/entity/decoration/ArmorStand;lastHit:J", opcode=180))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V")}, cancellable=true)
    private void impl$fireDamageEventFirstPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            DamageEventUtil.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.currentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), 0.0);
            if (SpongeCommon.post(event)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;brokenByPlayer(Lnet/minecraft/world/damagesource/DamageSource;)V")}, cancellable=true)
    private void impl$fireDamageEventSecondPunch(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.impl$fireDestroyDamageEvent(source, cir);
    }

    @Overwrite
    public void kill() {
        super.shadow$kill();
    }
}

