/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.world.entity.projectile.ProjectileMixin;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends ProjectileMixin {
    @Shadow
    private int life;
    @Shadow
    protected boolean inGround;
    @Shadow
    public int shakeTime;
    @Shadow
    public AbstractArrow.Pickup pickup;
    @Shadow
    @Nullable
    private BlockState lastState;
    @Nullable
    public ProjectileSource projectileSource;

    @Shadow
    public abstract void shadow$setCritArrow(boolean var1);

    @Shadow
    public abstract void shadow$setPierceLevel(byte var1);

    @Shadow
    public abstract void shadow$setShotFromCrossbow(boolean var1);

    @Shadow
    protected abstract ItemStack shadow$getPickupItem();

    @Shadow
    protected abstract void resetPiercedEntities();

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProjectileHit(BlockHitResult hitResult, CallbackInfo ci) {
        if (!((LevelBridge)this.level).bridge$isFake() && hitResult.getType() != HitResult.Type.MISS && SpongeCommonEventFactory.handleCollideImpactEvent((Entity)((AbstractArrow)this), this.impl$getProjectileSource(), (HitResult)hitResult)) {
            BlockState blockstate;
            this.shadow$playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            BlockHitResult blockraytraceresult = hitResult;
            this.lastState = blockstate = this.level.getBlockState(blockraytraceresult.getBlockPos());
            Vec3 vec3d = blockraytraceresult.getLocation().subtract(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ());
            this.shadow$setDeltaMovement(vec3d);
            Vec3 vec3d1 = vec3d.normalize().scale((double)0.05f);
            this.shadow$setPos(this.shadow$getX() - vec3d1.x, this.shadow$getY() - vec3d1.y, this.shadow$getZ() - vec3d1.z);
            this.inGround = true;
            this.shakeTime = 7;
            this.shadow$setCritArrow(false);
            this.shadow$setPierceLevel((byte)0);
            this.shadow$setShotFromCrossbow(false);
            this.resetPiercedEntities();
            ci.cancel();
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProjectileHit(EntityHitResult hitResult, CallbackInfo ci) {
        if (!((LevelBridge)this.level).bridge$isFake() && hitResult.getType() != HitResult.Type.MISS && SpongeCommonEventFactory.handleCollideImpactEvent((Entity)((AbstractArrow)this), this.impl$getProjectileSource(), (HitResult)hitResult)) {
            this.shadow$playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.shadow$setDeltaMovement(this.shadow$getDeltaMovement().scale(-0.1));
            this.shadow$setYRot(this.shadow$getYRot() + 180.0f);
            this.yRotO += 180.0f;
            this.life = 0;
            if (!this.level.isClientSide && this.shadow$getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.shadow$spawnAtLocation(this.shadow$getPickupItem(), 0.1f);
                }
                this.shadow$discard();
            }
            ci.cancel();
        }
    }

    @Inject(method={"tickDespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;discard()V")})
    private void impl$throwExpireArrow(CallbackInfo ci) {
        this.impl$callExpireEntityEvent();
    }
}

