/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.ThrowableProjectileMixin;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={ThrownEnderpearl.class})
public abstract class ThrownEnderpearlMixin
extends ThrowableProjectileMixin {
    private double impl$damageAmount;

    @ModifyArg(method={"onHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private float impl$onAttackEntityFromWithDamage(float damage) {
        return (float)this.impl$damageAmount;
    }

    @Inject(method={"onHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;teleportTo(DDD)V")}, cancellable=true)
    private void impl$callMoveEntityEventForThrower(HitResult result, CallbackInfo ci) {
        if (this.shadow$getCommandSenderWorld().isClientSide || !ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        net.minecraft.world.entity.Entity entity = this.shadow$getOwner();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENDER_PEARL);
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(frame.currentCause(), (Entity)entity, VecHelper.toVector3d(entity.position()), VecHelper.toVector3d(this.shadow$position()), VecHelper.toVector3d(this.shadow$position()));
            if (SpongeCommon.post(event)) {
                this.shadow$discard();
                ci.cancel();
                return;
            }
            Vector3d destinationPosition = event.destinationPosition();
            this.shadow$setPos(destinationPosition.x(), destinationPosition.y(), destinationPosition.z());
        }
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity impl$postProcessChangeDimension(net.minecraft.world.entity.Entity entity) {
        if (entity instanceof ThrownEnderpearl) {
            this.shadow$setOwner(null);
        }
        return entity;
    }
}

