/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={FireworkRocketItem.class})
public abstract class FireworkRocketItemMixin {
    private FireworkRocketEntity impl$capturedRocket;

    @Inject(method={"use"}, at={@At(value="NEW", target="net/minecraft/world/entity/projectile/FireworkRocketEntity")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void impl$throwPreBeforeSpawning(Level worldIn, Player playerIn, InteractionHand handIn, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir, ItemStack stack) {
        if (this.impl$throwConstructPreEvent(worldIn, playerIn, stack)) {
            cir.setReturnValue((Object)new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack));
        }
    }

    @Inject(method={"useOn"}, at={@At(value="NEW", target="net/minecraft/world/entity/projectile/FireworkRocketEntity")}, cancellable=true)
    private void impl$throwPrimeEventsIfCancelled(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.impl$throwConstructPreEvent(context.getLevel(), context.getPlayer(), context.getItemInHand())) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    private boolean impl$throwConstructPreEvent(Level world, Player player, ItemStack usedItem) {
        if (ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE && !((LevelBridge)world).bridge$isFake()) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.currentCause(), ServerLocation.of((ServerWorld)world, player.getX(), player.getY(), player.getZ()), new Vector3d(0.0f, 0.0f, 0.0f), EntityTypes.FIREWORK_ROCKET.get());
                boolean bl = SpongeCommon.post(event);
                return bl;
            }
        }
        return false;
    }

    @Inject(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$injectPrimeEventAndCancel(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir, Level world, ItemStack usedItem, Vec3 vec3d, Direction direction, FireworkRocketEntity rocket) {
        if (this.impl$throwPrimeEventAndGetCancel(context.getLevel(), context.getPlayer(), rocket, usedItem)) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean impl$captureFireworkRocket(Level world, Entity p_217376_1_) {
        this.impl$capturedRocket = (FireworkRocketEntity)p_217376_1_;
        return true;
    }

    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void impl$injectPrimeEventAndCancel(Level worldIn, Player player, InteractionHand handIn, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir, ItemStack usedItem) {
        if (this.impl$throwPrimeEventAndGetCancel(worldIn, player, this.impl$capturedRocket, usedItem)) {
            this.impl$capturedRocket = null;
            cir.setReturnValue((Object)new InteractionResultHolder(InteractionResult.SUCCESS, (Object)usedItem));
        }
        worldIn.addFreshEntity((Entity)this.impl$capturedRocket);
        this.impl$capturedRocket = null;
    }

    private boolean impl$throwPrimeEventAndGetCancel(Level world, Player player, FireworkRocketEntity rocket, ItemStack usedItem) {
        if (((LevelBridge)world).bridge$isFake()) {
            return false;
        }
        ((FireworkRocket)rocket).offer(Keys.SHOOTER, (org.spongepowered.api.entity.living.player.Player)player);
        if (ShouldFire.PRIME_EXPLOSIVE_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(usedItem));
                frame.addContext(EventContextKeys.PROJECTILE_SOURCE, (ProjectileSource)player);
                frame.pushCause(player);
                if (!((FusedExplosiveBridge)rocket).bridge$shouldPrime()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

