/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={FishingRodItem.class})
public abstract class FishingRodItemMixin {
    @Nullable
    private FishingHook impl$fishHook;

    @Inject(method={"use"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/projectile/FishingHook;retrieve(Lnet/minecraft/world/item/ItemStack;)I")}, cancellable=true)
    private void cancelHookRetraction(Level world, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (player.fishing != null) {
            cir.setReturnValue((Object)new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand)));
        }
    }

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=1)}, cancellable=true)
    private void onThrowEvent(Level world, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (world.isClientSide) {
            return;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        int k = EnchantmentHelper.getFishingSpeedBonus((ItemStack)itemstack);
        int j = EnchantmentHelper.getFishingLuckBonus((ItemStack)itemstack);
        FishingHook fishHook = new FishingHook(player, world, j, k);
        PhaseTracker.getCauseStackManager().pushCause(player);
        if (SpongeCommon.post(SpongeEventFactory.createFishingEventStart(PhaseTracker.getCauseStackManager().currentCause(), (FishingBobber)fishHook))) {
            fishHook.remove(Entity.RemovalReason.DISCARDED);
            cir.setReturnValue((Object)new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand)));
        } else {
            this.impl$fishHook = fishHook;
        }
        PhaseTracker.getCauseStackManager().popCause();
    }

    @Redirect(method={"use"}, at=@At(value="NEW", target="net/minecraft/world/entity/projectile/FishingHook"))
    private FishingHook onNewEntityFishHook(Player p_i50220_1_, Level p_i50220_2_, int p_i50220_3_, int p_i50220_4_) {
        FishingHook fishHook = this.impl$fishHook;
        this.impl$fishHook = null;
        return fishHook;
    }
}

