/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.CustomNameableBridge;
import org.spongepowered.common.bridge.world.level.block.entity.BannerBlockEntityBridge;
import org.spongepowered.common.data.provider.item.stack.ShieldItemStackData;
import org.spongepowered.common.mixin.core.world.level.block.entity.BlockEntityMixin;

@Mixin(value={BannerBlockEntity.class})
public abstract class BannerBlockEntityMixin
extends BlockEntityMixin
implements BannerBlockEntityBridge,
CustomNameableBridge {
    @Shadow
    private net.minecraft.world.item.DyeColor baseColor;
    @Shadow
    private ListTag itemPatterns;
    private List<BannerPatternLayer> impl$patternLayers = Lists.newArrayList();

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onSetItemValues(CallbackInfo ci) {
        this.impl$updatePatterns();
    }

    private void impl$markDirtyAndUpdate() {
        this.shadow$setChanged();
        if (this.level != null && !this.level.isClientSide) {
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.shadow$getBlockPos());
        }
    }

    private void impl$updatePatterns() {
        this.impl$patternLayers.clear();
        if (this.itemPatterns != null) {
            for (Tag pattern : this.itemPatterns) {
                this.impl$patternLayers.add(ShieldItemStackData.layerFromNbt((CompoundTag)pattern));
            }
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public List<BannerPatternLayer> bridge$getLayers() {
        return new ArrayList<BannerPatternLayer>(this.impl$patternLayers);
    }

    @Override
    public void bridge$setLayers(List<BannerPatternLayer> layers) {
        this.impl$patternLayers = NonNullList.create();
        this.impl$patternLayers.addAll(layers);
        this.itemPatterns = new ListTag();
        for (BannerPatternLayer layer : this.impl$patternLayers) {
            this.itemPatterns.add((Object)ShieldItemStackData.layerToNbt(layer));
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public DyeColor bridge$getBaseColor() {
        return (DyeColor)this.baseColor;
    }

    @Override
    public void bridge$setBaseColor(DyeColor baseColor) {
        Preconditions.checkNotNull((Object)baseColor, (Object)"Null DyeColor!");
        try {
            this.baseColor = (net.minecraft.world.item.DyeColor)baseColor;
        }
        catch (Exception e) {
            this.baseColor = net.minecraft.world.item.DyeColor.BLACK;
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public void bridge$setCustomDisplayName(Component customName) {
        ((BannerBlockEntity)this).setCustomName(customName);
    }
}

