/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.entity;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.EntityCollisionCategory;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={net.minecraft.world.entity.Entity.class}, priority=1002)
public abstract class EntityMixin_EntityCollision
implements CollisionCapabilityBridge {
    private ResourceKey entityCollision$key;
    private int entityCollision$maxCollisions = 8;
    private boolean entityCollision$refreshCache = false;

    @Shadow
    public abstract Level shadow$getCommandSenderWorld();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void collisions$InjectActivationInformation(EntityType<?> type, Level world, CallbackInfo ci) {
        if (world != null && !((LevelBridge)world).bridge$isFake() && ((PrimaryLevelDataBridge)world.getLevelData()).bridge$valid()) {
            if ((net.minecraft.world.entity.Entity)this instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)this;
                ItemStack itemstack = item.getItem();
                if (!itemstack.isEmpty()) {
                    this.entityCollision$key = Sponge.game().registry(RegistryTypes.ITEM_TYPE).valueKey(((org.spongepowered.api.item.inventory.ItemStack)itemstack).type());
                }
            } else {
                this.entityCollision$key = Sponge.game().registry(RegistryTypes.ENTITY_TYPE).valueKey(((Entity)((Object)this)).type());
            }
            if (!this.shadow$getCommandSenderWorld().isClientSide()) {
                this.collision$initializeCollisionState(this.shadow$getCommandSenderWorld());
            }
        }
    }

    @Override
    public ResourceKey collision$getKey() {
        return this.entityCollision$key;
    }

    @Override
    public int collision$getMaxCollisions() {
        return this.entityCollision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.entityCollision$maxCollisions = max;
    }

    @Override
    public void collision$initializeCollisionState(Level world) {
        InheritableConfigHandle<WorldConfig> worldConfigAdapter = ((PrimaryLevelDataBridge)world.getLevelData()).bridge$configAdapter();
        ConfigHandle<CommonConfig> globalConfigAdapter = SpongeConfigs.getCommon();
        EntityCollisionCategory.ModSubCategory worldCollMod = worldConfigAdapter.getOrCreateValue(s -> s.entityCollision.mods.get(this.entityCollision$key.namespace()), c -> {
            EntityCollisionCategory.ModSubCategory globalCollision = new EntityCollisionCategory.ModSubCategory(this.entityCollision$key.namespace());
            c.entityCollision.mods.put(this.entityCollision$key.namespace(), globalCollision);
            globalCollision.entities.put(this.entityCollision$key.namespace(), this.collision$getMaxCollisions());
        }, ((WorldConfig)worldConfigAdapter.get()).entityCollision.autoPopulate);
        EntityCollisionCategory worldCollCat = ((WorldConfig)worldConfigAdapter.get()).entityCollision;
        this.collision$setMaxCollisions(worldCollCat.maxEntitiesWithinAABB);
        boolean requiresSave = false;
        if (worldCollMod != null) {
            if (!worldCollMod.enabled) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.entityDefault;
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            Integer entityMaxCollision = null;
            if ((net.minecraft.world.entity.Entity)this instanceof ItemEntity) {
                entityMaxCollision = worldCollMod.entities.get(this.entityCollision$key.value());
            }
            if (entityMaxCollision == null) {
                entityMaxCollision = worldCollMod.entities.get(this.entityCollision$key.value());
            }
            if (entityMaxCollision == null && worldCollCat.autoPopulate) {
                requiresSave = true;
            } else if (entityMaxCollision != null) {
                this.collision$setMaxCollisions(entityMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.entityCollision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.entityCollision$refreshCache;
    }

    @Override
    public boolean collision$isRunningCollideWithNearby() {
        return false;
    }
}

