/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.server.level;

import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerInventoryBridge;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.mixin.inventory.event.entity.player.PlayerMixin_Inventory;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin_Inventory
extends PlayerMixin_Inventory {
    private @Nullable EffectTransactor inventory$effectTransactor = null;
    private @Nullable Object inventory$menuProvider;

    ServerPlayerMixin_Inventory(EntityType<?> param0, Level param1) {
        super(param0, param1);
    }

    @Override
    protected void impl$beforeSetItemSlot(EquipmentSlot param0, ItemStack param1, CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        this.inventory$effectTransactor = transactor.logPlayerInventoryChangeWithEffect((Player)this, PlayerInventoryTransaction.EventCreator.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void impl$afterSetItemSlot(EquipmentSlot param0, ItemStack param1, CallbackInfo ci) {
        try (EffectTransactor ignored = this.inventory$effectTransactor;){
            this.inventoryMenu.broadcastChanges();
        }
        finally {
            this.inventory$effectTransactor = null;
        }
    }

    @Inject(method={"drop(Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;removeFromSelected(Z)Lnet/minecraft/world/item/ItemStack;")})
    protected void impl$beforeRemoveItem(boolean param0, CallbackInfoReturnable<Boolean> cir) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        this.inventory$effectTransactor = transactor.logDropFromPlayerInventory((ServerPlayer)this, param0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"drop(Z)Z"}, at={@At(value="RETURN")})
    protected void impl$onPlayerDrop(boolean param0, CallbackInfoReturnable<Boolean> cir) {
        try (EffectTransactor ignored = this.inventory$effectTransactor;){
            this.containerMenu.broadcastChanges();
        }
        finally {
            this.inventory$effectTransactor = null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void inventory$switchToCloseWindowState(AbstractContainerMenu container, Player player) {
        if (Sponge.isServerAvailable() && Sponge.isClientAvailable()) {
            container.removed(player);
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        try (@NonNull P ctx = ((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext(PhaseTracker.SERVER).source(serverPlayer)).packetPlayer(serverPlayer);){
            ((PhaseContext)ctx).buildAndSwitch();
            try (EffectTransactor ignored = ((PhaseContext)ctx).getTransactor().logCloseInventory(player, true);){
                container.removed(player);
                container.broadcastChanges();
            }
        }
        this.impl$onCloseMenu();
    }

    @Override
    protected void inventory$onTouch(Entity entity, Player player) {
        if (entity instanceof ItemEntity) {
            entity.playerTouch(player);
            return;
        }
        if (!((EntityBridge)entity).bridge$isPlayerTouchDeclared()) {
            entity.playerTouch(player);
            return;
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        try (EffectTransactor ignored = context.getTransactor().logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.STANDARD);){
            entity.playerTouch(player);
            this.inventoryMenu.broadcastChanges();
        }
    }

    @Override
    protected void inventory$onHandleHandSwap(Map<EquipmentSlot, ItemStack> map, CallbackInfo ci) {
    }

    @Override
    protected void inventory$onUpdateUsingItem(LivingEntity thisPlayer) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect((Player)((ServerPlayer)this), PlayerInventoryTransaction.EventCreator.STANDARD);){
            this.shadow$completeUsingItem();
            this.inventoryMenu.broadcastChanges();
        }
    }

    @Inject(method={"openMenu"}, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayer;containerMenu:Lnet/minecraft/world/inventory/AbstractContainerMenu;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$afterOpenMenu(MenuProvider param0, CallbackInfoReturnable<OptionalInt> cir) {
        PhaseTracker.SERVER.getPhaseContext().getTransactor().logContainerSet((Player)((ServerPlayer)this));
    }

    @Inject(method={"openMenu"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;initMenu(Lnet/minecraft/world/inventory/AbstractContainerMenu;)V")})
    private void impl$onOpenMenu(MenuProvider $$0, CallbackInfoReturnable<OptionalInt> cir) {
        this.inventory$menuProvider = $$0;
    }

    @Inject(method={"openHorseInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;initMenu(Lnet/minecraft/world/inventory/AbstractContainerMenu;)V")})
    private void impl$onOpenHorseInventory(AbstractHorse horse, Container inventoryIn, CallbackInfo ci) {
        this.inventory$menuProvider = inventoryIn;
    }

    @Inject(method={"initMenu"}, at={@At(value="HEAD")})
    private void impl$onInitMenu(AbstractContainerMenu $$0, CallbackInfo ci) {
        Object object = this.inventory$menuProvider;
        if (object instanceof ViewableInventoryBridge) {
            ViewableInventoryBridge bridge = (ViewableInventoryBridge)object;
            bridge.viewableBridge$addPlayer((ServerPlayer)this);
        }
    }

    @Inject(method={"doCloseContainer"}, at={@At(value="RETURN")})
    private void impl$onDoCloseContainer(CallbackInfo ci) {
        this.impl$onCloseMenu();
    }

    private void impl$onCloseMenu() {
        Object object = this.inventory$menuProvider;
        if (object instanceof ViewableInventoryBridge) {
            ViewableInventoryBridge bridge = (ViewableInventoryBridge)object;
            bridge.viewableBridge$removePlayer((ServerPlayer)this);
        }
        this.inventory$menuProvider = null;
    }

    @Redirect(method={"openMenu"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/MenuProvider;createMenu(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/inventory/AbstractContainerMenu;"))
    private AbstractContainerMenu impl$transactMenuCreationWithEffect(MenuProvider menuProvider, int var1, net.minecraft.world.entity.player.Inventory var2, Player var3) {
        try (EffectTransactor ignored = PhaseTracker.SERVER.getPhaseContext().getTransactor().logOpenInventory((Player)((ServerPlayer)this));){
            AbstractContainerMenu abstractContainerMenu = menuProvider.createMenu(var1, var2, var3);
            return abstractContainerMenu;
        }
    }

    @Override
    protected Slot impl$getSpongeSlot(EquipmentSlot equipmentSlot) {
        EquipmentType equipmentType = (EquipmentType)equipmentSlot;
        PlayerInventoryBridge inventory = (PlayerInventoryBridge)((ServerPlayer)this).getInventory();
        Lens lens = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getRootLens();
        Fabric fabric = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getFabric();
        if (lens instanceof PlayerInventoryLens) {
            SlotLens slotLens = ((PlayerInventoryLens)lens).getEquipmentLens().getSlotLens(equipmentType);
            return slotLens.getAdapter(fabric, (Inventory)((Object)inventory));
        }
        throw new IllegalStateException("Unknown Lens for Player Inventory: " + lens.getClass().getName());
    }
}

