/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.entity.item;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin_Inventory {
    @Shadow
    private int pickupDelay;

    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;")}, cancellable=true)
    private void spongeImpl$ThrowPickupEvent(Player entityIn, CallbackInfo ci) {
        if (this.pickupDelay == 0 && !InventoryEventFactory.callPlayerChangeInventoryPickupPreEvent(entityIn, (ItemEntity)this)) {
            ci.cancel();
        }
    }

    @Redirect(method={"playerTouch"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean spongeImpl$throwPickupEventForAddItem(Inventory inventory, ItemStack itemStack, Player player) {
        boolean added;
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.PICKUP);){
            added = inventory.add(itemStack);
        }
        if (!TrackingUtil.processBlockCaptures(context)) {
            return false;
        }
        return added;
    }
}

