/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.movementcheck.server.network;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin_MovementCheck {
    @Shadow
    public ServerPlayer player;

    @Redirect(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z", ordinal=0))
    private boolean movementCheck$onPlayerMovedTooQuicklyCheck(ServerPlayer player) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.player.movedTooQuickly) {
            return player.isChangingDimension();
        }
        return true;
    }

    @Redirect(method={"handleMovePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z", ordinal=1))
    private boolean movementCheck$onMovedWronglyCheck(ServerPlayer player) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.movedWrongly) {
            return player.isChangingDimension();
        }
        return true;
    }

    @ModifyConstant(method={"handleMoveVehicle"}, constant={@Constant(doubleValue=100.0, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;lengthSqr()D", ordinal=0), to=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z", ordinal=0))})
    private double movementCheck$onVehicleMovedTooQuicklyCheck(double val) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.player.vehicleMovedTooQuickly) {
            return val;
        }
        return Double.NaN;
    }

    @ModifyConstant(method={"handleMoveVehicle"}, constant={@Constant(doubleValue=0.0625, ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", ordinal=0), to=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", ordinal=0, remap=false))})
    private double movementCheck$onMovedWronglySecond(double val) {
        if (((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.player.level).get()).movementChecks.movedWrongly) {
            return val;
        }
        return Double.NaN;
    }
}

