/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.entity.item;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.block.Blocks;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.mixin.tracker.world.entity.EntityMixin_Tracker;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin_Tracker
extends EntityMixin_Tracker {
    @Override
    protected void tracker$populateDeathContextIfNeeded(CauseStackManager.StackFrame frame, EntityTickContext context) {
        context.getCreator().ifPresent(frame::pushCause);
        super.tracker$populateDeathContextIfNeeded(frame, context);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void tracker$handleBlockCapture(CallbackInfo ci) {
        BlockPos pos = new BlockPos(this.shadow$getX(), this.shadow$getY(), this.shadow$getZ());
        if (((LevelBridge)this.level).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT) {
            return;
        }
        PhaseContext<@NonNull ?> currentContext = PhaseTracker.getInstance().getPhaseContext();
        if (currentContext.doesBlockEventTracking()) {
            if (!TrackingUtil.processBlockCaptures(currentContext)) {
                this.shadow$remove(Entity.RemovalReason.DISCARDED);
                ci.cancel();
            }
        } else if (this.level.getBlockState(pos) != Blocks.AIR.defaultBlockState()) {
            this.shadow$remove(Entity.RemovalReason.DISCARDED);
            ci.cancel();
        }
    }
}

