/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.ticks;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.ScheduledTick;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.ticks.ScheduledTickBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.DeferredScheduledUpdatePhaseState;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;

@Mixin(value={LevelTicks.class})
public abstract class LevelTicksMixin_Tracker {
    @Shadow
    @Final
    private List<ScheduledTick<?>> alreadyRunThisTick;

    @Redirect(method={"schedule(Lnet/minecraft/world/ticks/ScheduledTick;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/ticks/LevelChunkTicks;schedule(Lnet/minecraft/world/ticks/ScheduledTick;)V"))
    private void tracker$associatePhaseContextWithTickEntry(LevelChunkTicks instance, ScheduledTick<?> scheduledTick) {
        instance.schedule(scheduledTick);
    }

    @Redirect(method={"runCollectedTicks"}, at=@At(value="INVOKE", target="Ljava/util/function/BiConsumer;accept(Ljava/lang/Object;Ljava/lang/Object;)V"))
    private void tracker$wrapTickConsumer(BiConsumer consumer, Object blockPos, Object ticking) {
        ScheduledTick<?> thisScheduledTick = this.alreadyRunThisTick.get(this.alreadyRunThisTick.size() - 1);
        if (((ScheduledTickBridge)thisScheduledTick).bridge$isPartOfWorldGeneration()) {
            try (DeferredScheduledUpdatePhaseState.Context context = ((DeferredScheduledUpdatePhaseState.Context)GenerationPhase.State.DEFERRED_SCHEDULED_UPDATE.createPhaseContext(PhaseTracker.SERVER).source(this)).scheduledUpdate((BlockPos)blockPos, ticking);){
                context.buildAndSwitch();
                consumer.accept(blockPos, ticking);
            }
        } else {
            consumer.accept(blockPos, ticking);
        }
    }
}

