/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.Optional;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.ChatFormatting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplaySlot
implements DisplaySlot {
    private final int id;
    private final @Nullable ChatFormatting formatting;
    private @Nullable NamedTextColor color;

    public static int slotIdFromFormatting(ChatFormatting formatting) {
        return formatting.getId() + 3;
    }

    public SpongeDisplaySlot(int id) {
        this(id, null);
    }

    public SpongeDisplaySlot(ChatFormatting color) {
        this(SpongeDisplaySlot.slotIdFromFormatting(color), color);
    }

    private SpongeDisplaySlot(int id, @Nullable ChatFormatting color) {
        this.id = id;
        this.formatting = color;
    }

    @Override
    public @NonNull Optional<NamedTextColor> teamColor() {
        if (this.color == null) {
            this.color = SpongeAdventure.asAdventureNamed(this.formatting);
        }
        return Optional.ofNullable(this.color);
    }

    public int index() {
        return this.id;
    }
}

