/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.ChatFormatting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplaySlotFactory
implements DisplaySlot.Factory {
    @Override
    public @NonNull Optional<DisplaySlot> findByTeamColor(@NonNull NamedTextColor color) {
        DefaultedRegistryReference<DisplaySlot> slot = ColorMapping.COLOR_TO_DISPLAY_SLOT_MAP.get(SpongeAdventure.asVanilla(color));
        if (slot != null) {
            return slot.find();
        }
        return Optional.empty();
    }

    public static final class ColorMapping {
        public static final Map<ChatFormatting, DefaultedRegistryReference<DisplaySlot>> COLOR_TO_DISPLAY_SLOT_MAP;

        private ColorMapping() {
        }

        static {
            HashMap<ChatFormatting, DefaultedRegistryReference<DisplaySlot>> map = new HashMap<ChatFormatting, DefaultedRegistryReference<DisplaySlot>>();
            map.put(ChatFormatting.AQUA, DisplaySlots.SIDEBAR_TEAM_AQUA);
            map.put(ChatFormatting.BLACK, DisplaySlots.SIDEBAR_TEAM_BLACK);
            map.put(ChatFormatting.BLUE, DisplaySlots.SIDEBAR_TEAM_BLUE);
            map.put(ChatFormatting.DARK_AQUA, DisplaySlots.SIDEBAR_TEAM_DARK_AQUA);
            map.put(ChatFormatting.DARK_BLUE, DisplaySlots.SIDEBAR_TEAM_DARK_BLUE);
            map.put(ChatFormatting.DARK_GRAY, DisplaySlots.SIDEBAR_TEAM_DARK_GRAY);
            map.put(ChatFormatting.DARK_GREEN, DisplaySlots.SIDEBAR_TEAM_DARK_GREEN);
            map.put(ChatFormatting.DARK_PURPLE, DisplaySlots.SIDEBAR_TEAM_DARK_PURPLE);
            map.put(ChatFormatting.DARK_RED, DisplaySlots.SIDEBAR_TEAM_DARK_RED);
            map.put(ChatFormatting.GOLD, DisplaySlots.SIDEBAR_TEAM_GOLD);
            map.put(ChatFormatting.GRAY, DisplaySlots.SIDEBAR_TEAM_GRAY);
            map.put(ChatFormatting.GREEN, DisplaySlots.SIDEBAR_TEAM_GREEN);
            map.put(ChatFormatting.LIGHT_PURPLE, DisplaySlots.SIDEBAR_TEAM_LIGHT_PURPLE);
            map.put(ChatFormatting.RED, DisplaySlots.SIDEBAR_TEAM_RED);
            map.put(ChatFormatting.WHITE, DisplaySlots.SIDEBAR_TEAM_WHITE);
            map.put(ChatFormatting.YELLOW, DisplaySlots.SIDEBAR_TEAM_YELLOW);
            COLOR_TO_DISPLAY_SLOT_MAP = Collections.unmodifiableMap(map);
        }
    }
}

