/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.SpongeSubjectCollection;
import org.spongepowered.plugin.PluginContainer;

class SpongePermissionDescription
implements PermissionDescription {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\.<[a-zA-Z0-9_-]+>");
    private static final Pattern PERMISSION_FORMAT = Pattern.compile("^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*(\\.<[a-zA-Z0-9_-]+>)?$");
    private final SpongePermissionService permissionService;
    private final String id;
    private final String strippedId;
    private final @Nullable Component description;
    private final PluginContainer owner;

    SpongePermissionDescription(SpongePermissionService permissionService, String id, String strippedId, @Nullable Component description, PluginContainer owner) {
        this.permissionService = permissionService;
        this.id = id;
        this.strippedId = strippedId;
        this.description = description;
        this.owner = owner;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Optional<Component> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Map<? extends Subject, Boolean> assignedSubjects(String identifier) {
        SpongeSubjectCollection subjects = this.permissionService.get(identifier);
        return subjects.loadedWithPermission(this.strippedId);
    }

    @Override
    public boolean query(Subject subj) {
        return subj.hasPermission(this.strippedId);
    }

    @Override
    public boolean query(Subject subj, ResourceKey key) {
        return subj.hasPermission(this.strippedId + "." + key.namespace() + "." + key.value());
    }

    @Override
    public boolean query(Subject subj, String ... parameters) {
        if (parameters.length == 0) {
            return this.query(subj);
        }
        if (parameters.length == 1) {
            return this.query(subj, parameters[0]);
        }
        StringBuilder build = new StringBuilder(this.strippedId);
        for (String parameter : parameters) {
            build.append('.').append(parameter);
        }
        return subj.hasPermission(build.toString());
    }

    @Override
    public boolean query(Subject subj, String parameter) {
        String extendedPermission = this.strippedId + "." + Objects.requireNonNull(parameter, "parameter");
        return subj.hasPermission(extendedPermission);
    }

    @Override
    public CompletableFuture<? extends Map<? extends SubjectReference, Boolean>> findAssignedSubjects(String type) {
        SpongeSubjectCollection subjects = this.permissionService.get(type);
        return subjects.allWithPermission(this.strippedId);
    }

    @Override
    public Optional<PluginContainer> owner() {
        return Optional.of(this.owner);
    }

    @Override
    public Tristate defaultValue() {
        return this.permissionService.defaults().permissionValue(this.strippedId);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SpongePermissionDescription that = (SpongePermissionDescription)other;
        return this.id.equals(that.id) && this.owner.equals(that.owner) && this.description.equals(that.description);
    }

    public String toString() {
        return "SpongePermissionDescription{owner=" + this.owner + ", id=" + this.id + ", description=" + this.description + "}";
    }

    static class Builder
    implements PermissionDescription.Builder {
        private final SpongePermissionService permissionService;
        private final PluginContainer owner;
        private String id;
        private @Nullable Component description;
        private final Map<String, Tristate> roleAssignments = new LinkedHashMap<String, Tristate>();
        private Tristate defaultValue = Tristate.UNDEFINED;

        Builder(SpongePermissionService permissionService, PluginContainer owner) {
            this.permissionService = Objects.requireNonNull(permissionService, "permissionService");
            this.owner = Objects.requireNonNull(owner, "owner");
        }

        @Override
        public Builder id(String id) {
            if (!PERMISSION_FORMAT.matcher(Objects.requireNonNull(id, "permissionId")).matches()) {
                throw new IllegalArgumentException("Input permission '" + this.id + "' is not in the allowed format '" + PERMISSION_FORMAT.pattern() + "'");
            }
            this.id = id;
            return this;
        }

        @Override
        public Builder description(@Nullable Component description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder assign(String role, boolean value) {
            Objects.requireNonNull(role, "role");
            this.roleAssignments.put(role, Tristate.fromBoolean(value));
            return this;
        }

        @Override
        public Builder defaultValue(Tristate defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            return this;
        }

        @Override
        public SpongePermissionDescription register() throws IllegalStateException {
            if (this.id == null) {
                throw new IllegalStateException("No id set");
            }
            String strippedId = PLACEHOLDER.matcher(this.id).replaceAll("");
            SpongePermissionDescription description = new SpongePermissionDescription(this.permissionService, this.id, strippedId, this.description, this.owner);
            this.permissionService.addDescription(description);
            if (this.defaultValue != Tristate.UNDEFINED) {
                this.permissionService.defaults().transientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, strippedId, this.defaultValue);
            }
            SpongeSubjectCollection subjects = this.permissionService.get("role-template");
            for (Map.Entry<String, Tristate> assignment : this.roleAssignments.entrySet()) {
                SpongeSubject subject = subjects.get(assignment.getKey());
                subject.transientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, strippedId, assignment.getValue());
            }
            return description;
        }
    }
}

