/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.function.Supplier;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.util.DataUtil;

public final class BoundedUtil {
    public static Value<Double> constructImmutableValueDouble(Double value, Supplier<? extends Key<? extends Value<Double>>> key, Property<Double> property) {
        double min = DataUtil.mind(property);
        double max = DataUtil.maxd(property);
        return Value.immutableOf(key, value < min || value > max ? null : value);
    }

    public static Value<Double> constructMutableValueDouble(Double value, Supplier<? extends Key<? extends Value<Double>>> key, Property<Double> property) {
        double min = DataUtil.mind(property);
        double max = DataUtil.maxd(property);
        return Value.mutableOf(key, value < min || value > max ? null : value);
    }

    public static Value<Integer> constructImmutableValueInteger(Integer value, Key<? extends Value<Integer>> key, IntegerProperty property) {
        int min = DataUtil.mini(property);
        int max = DataUtil.maxi(property);
        return Value.immutableOf(key, value < min || value > max ? null : value);
    }

    public static Value<Integer> constructMutableValueInteger(Integer value, Supplier<? extends Key<? extends Value<Integer>>> key, IntegerProperty property) {
        int min = DataUtil.mini(property);
        int max = DataUtil.maxi(property);
        return Value.mutableOf(key, value < min || value > max ? null : value);
    }

    public static <O, H extends StateHolder<O, H>> H setDouble(H holder, Double value, Property<Double> property) {
        double min = DataUtil.mind(property);
        double max = DataUtil.maxd(property);
        if (value < min || value > max) {
            return holder;
        }
        return (H)((StateHolder)holder.setValue(property, (Comparable)value));
    }

    public static <O, H extends StateHolder<O, H>> H setDoubleLower(H holder, Double value, Property<Double> property) {
        double min = DataUtil.mind(property);
        if (value < min) {
            return holder;
        }
        return (H)((StateHolder)holder.setValue(property, (Comparable)value));
    }

    public static <O, H extends StateHolder<O, H>> H setDoubleUpper(H holder, Double value, Property<Double> property) {
        double max = DataUtil.maxd(property);
        if (value > max) {
            return holder;
        }
        return (H)((StateHolder)holder.setValue(property, (Comparable)value));
    }

    public static <O, H extends StateHolder<O, H>> H setInteger(H holder, Integer value, IntegerProperty property) {
        int min = DataUtil.mini(property);
        int max = DataUtil.maxi(property);
        if (value < min || value > max) {
            return holder;
        }
        return (H)((StateHolder)holder.setValue((Property)property, (Comparable)value));
    }

    public static <O, H extends StateHolder<O, H>> H setIntegerLower(H holder, Integer value, IntegerProperty property) {
        int min = DataUtil.mini(property);
        if (value < min) {
            return holder;
        }
        return (H)((StateHolder)holder.setValue((Property)property, (Comparable)value));
    }

    public static <O, H extends StateHolder<O, H>> H setIntegerUpper(H holder, Integer value, IntegerProperty property) {
        int max = DataUtil.maxi(property);
        if (value > max) {
            return holder;
        }
        return (H)((StateHolder)holder.setValue((Property)property, (Comparable)value));
    }

    private BoundedUtil() {
    }
}

