/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.leangen.geantyref.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.common.SpongeCommon;

public final class UsernameCache {
    private static final Charset CHARSET = Charsets.UTF_8;
    private final Map<UUID, String> usernameByUniqueId = new ConcurrentHashMap<UUID, String>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path cacheFile;
    private boolean dirty = false;

    public UsernameCache(Server server) {
        this.cacheFile = server.game().gameDirectory().resolve("usernamecache.json");
    }

    public void setUsername(UUID uniqueId, String username) {
        Preconditions.checkNotNull((Object)uniqueId);
        Preconditions.checkNotNull((Object)username);
        if (username.equals(this.usernameByUniqueId.get(uniqueId))) {
            return;
        }
        this.usernameByUniqueId.put(uniqueId, username);
        this.dirty = true;
    }

    public boolean removeUsername(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId);
        if (this.usernameByUniqueId.remove(uniqueId) != null) {
            this.dirty = true;
            return true;
        }
        return false;
    }

    public @Nullable String getLastKnownUsername(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId);
        return this.usernameByUniqueId.get(uniqueId);
    }

    public @Nullable UUID getLastKnownUUID(String username) {
        Preconditions.checkNotNull((Object)username);
        for (Map.Entry<UUID, String> mapEntry : this.usernameByUniqueId.entrySet()) {
            if (!mapEntry.getValue().equalsIgnoreCase(username)) continue;
            return mapEntry.getKey();
        }
        return null;
    }

    public boolean containsUUID(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId);
        return this.usernameByUniqueId.containsKey(uniqueId);
    }

    public Map<UUID, String> getAll() {
        return Collections.unmodifiableMap(this.usernameByUniqueId);
    }

    public void load() {
        this.usernameByUniqueId.clear();
        if (Files.notExists(this.cacheFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.cacheFile, CHARSET);){
            Type type = new TypeToken<Map<UUID, String>>(){
                private static final long serialVersionUID = 1L;
            }.getType();
            this.usernameByUniqueId.putAll((Map)this.gson.fromJson((Reader)reader, type));
        }
        catch (JsonSyntaxException e) {
            SpongeCommon.logger().error("Could not parse username cache file as valid json, deleting file", (Throwable)e);
            this.deleteCacheFile();
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Failed to read username cache file from disk, deleting file", (Throwable)e);
            this.deleteCacheFile();
        }
    }

    private void deleteCacheFile() {
        try {
            Files.deleteIfExists(this.cacheFile);
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Failed to delete username cache file from disk!", (Throwable)e);
        }
    }

    public void save() {
        if (!this.dirty) {
            return;
        }
        try {
            String serialized = this.gson.toJson(this.usernameByUniqueId);
            Files.write(this.cacheFile, serialized.getBytes(CHARSET), new OpenOption[0]);
            this.dirty = false;
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Failed to save username cache to file!", (Throwable)e);
        }
    }
}

