/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.raytrace.AbstractSpongeRayTrace;
import org.spongepowered.common.util.raytrace.SpongeRayTraceResult;

public final class SpongeBlockRayTrace
extends AbstractSpongeRayTrace<LocatableBlock> {
    private static final Predicate<LocatableBlock> DEFAULT_FILTER = block -> {
        BlockType type = block.blockState().type();
        return type != BlockTypes.CAVE_AIR.get() && type != BlockTypes.VOID_AIR.get() && type != BlockTypes.AIR.get();
    };

    SpongeBlockRayTrace() {
        super(DEFAULT_FILTER);
    }

    @Override
    final Optional<RayTraceResult<@NonNull LocatableBlock>> testSelectLocation(ServerWorld serverWorld, Vec3 location, Vec3 exitLocation) {
        LocatableBlock initialBlock = this.getBlock(serverWorld, location, exitLocation);
        if (this.select.test(initialBlock)) {
            return Optional.of(new SpongeRayTraceResult<LocatableBlock>(initialBlock, VecHelper.toVector3d(location)));
        }
        return Optional.empty();
    }
}

