/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.entity.EntitySection;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.accessor.client.multiplayer.ClientLevelAccessor;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.accessor.world.level.block.entity.BlockEntityAccessor;
import org.spongepowered.common.accessor.world.level.entity.PersistentEntitySectionManagerAccessor;
import org.spongepowered.common.accessor.world.level.entity.TransientEntitySectionManagerAccessor;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.ChunkCursor;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class VolumeStreamUtils {
    private VolumeStreamUtils() {
    }

    public static <T> Supplier<T> createWeaklyReferencedSupplier(T object, String name) {
        WeakReference weakReference = new WeakReference(object);
        return () -> {
            @Nullable T weaklyReferenced = weakReference.get();
            return Objects.requireNonNull(weaklyReferenced, () -> String.format("%s de-referenced!", name));
        };
    }

    public static <MC, T> Registry<T> nativeToSpongeRegistry(net.minecraft.core.Registry<MC> registry) {
        return (Registry)registry;
    }

    public static Predicate<Tuple<Vector3d, EntityArchetype>> entityArchetypePositionFilter(Vector3i min, Vector3i max) {
        return VolumeStreamUtils.filterPositions(tuple -> ((Vector3d)tuple.first()).toInt(), min, max);
    }

    public static Predicate<Map.Entry<Vector3i, BlockEntityArchetype>> blockEntityArchetypePositionFilter(Vector3i min, Vector3i max) {
        return VolumeStreamUtils.filterPositions(Map.Entry::getKey, min, max);
    }

    public static <T> Predicate<T> filterPositions(Function<T, Vector3i> pos, Vector3i min, Vector3i max) {
        return entity -> {
            Vector3i apply = (Vector3i)pos.apply(entity);
            return apply.x() >= min.x() && apply.x() <= max.x() && apply.y() >= min.y() && apply.y() <= max.y() && apply.z() >= min.z() && apply.z() <= max.z();
        };
    }

    public static <R extends Region<R>> BiFunction<R, ChunkPos, @Nullable ChunkAccess> getChunkAccessorByStatus(LevelReader worldReader, boolean shouldGenerate) {
        Supplier<LevelReader> readerSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(worldReader, "IWorldReader");
        return (world, chunkPos) -> {
            ChunkStatus chunkStatus = shouldGenerate ? ChunkStatus.FULL : ChunkStatus.EMPTY;
            @Nullable ChunkAccess ichunk = ((LevelReader)readerSupplier.get()).getChunk(chunkPos.x, chunkPos.z, chunkStatus, shouldGenerate);
            if (shouldGenerate) {
                Objects.requireNonNull(ichunk, "Chunk was expected to load fully and generate, but somehow got a null chunk!");
            }
            if (ichunk instanceof ImposterProtoChunk) {
                return ((ImposterProtoChunk)ichunk).getWrapped();
            }
            return ichunk;
        };
    }

    public static Function<ChunkAccess, Stream<Map.Entry<BlockPos, net.minecraft.world.level.biome.Biome>>> getBiomesForChunkByPos(LevelReader reader, Vector3i min, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBiomeGetter().asTri(reader), min, max);
    }

    public static Function<ChunkAccess, Stream<Map.Entry<BlockPos, BlockState>>> getBlockStatesForSections(Vector3i min, Vector3i max) {
        return VolumeStreamUtils.getElementByPosition(VolumeStreamUtils.chunkSectionBlockStateGetter(), min, max);
    }

    public static boolean setBiomeOnNativeChunk(int x, int y, int z, Biome biome, Supplier<@Nullable LevelChunkSection> accessor, Runnable finalizer) {
        @Nullable LevelChunkSection section = accessor.get();
        if (section == null) {
            return false;
        }
        int maskedX = x & 3;
        int maskedY = y & 3;
        int maskedZ = z & 3;
        section.getBiomes().set(maskedX, maskedY, maskedZ, (Object)((net.minecraft.world.level.biome.Biome)biome));
        finalizer.run();
        return true;
    }

    public static void validateStreamArgs(Vector3i min, Vector3i max, StreamOptions options) {
        Objects.requireNonNull(min, "Minimum coordinates cannot be null");
        Objects.requireNonNull(max, "Maximum coordinates cannot be null");
        Objects.requireNonNull(options, "StreamOptions cannot be null!");
        if (min.x() > max.x()) {
            throw new IllegalArgumentException("Min(x) must be greater than max(x)!");
        }
        if (min.y() > max.y()) {
            throw new IllegalArgumentException("Min(y) must be greater than max y!");
        }
        if (min.z() > max.z()) {
            throw new IllegalArgumentException("Min(z) must be greater than max z!");
        }
    }

    public static void validateStreamArgs(Vector3i min, Vector3i max, Vector3i existingMin, Vector3i existingMax, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, options);
        if (existingMin.compareTo(Objects.requireNonNull(min, "Minimum coordinates cannot be null!")) < 0) {
            throw new IllegalArgumentException(String.format("Minimum %s cannot be lower than the current minimum coordinates: %s", min, existingMin));
        }
        if (existingMax.compareTo(Objects.requireNonNull(max, "Minimum coordinates cannot be null!")) < 0) {
            throw new IllegalArgumentException(String.format("Maximum %s cannot be greater than the current maximum coordinates: %s", max, existingMax));
        }
    }

    public static @NonNull Stream<Map.Entry<BlockPos, net.minecraft.world.entity.Entity>> getEntitiesFromChunk(Vector3i min, Vector3i max, LevelChunk chunk) {
        if (chunk.getLevel() instanceof ServerLevel) {
            return ((PersistentEntitySectionManagerAccessor)((ServerLevelAccessor)chunk.getLevel()).accessor$getEntityManager()).accessor$sectionStorage().getExistingSectionsInChunk(SectionPos.of((ChunkPos)chunk.getPos(), (int)0).asLong()).flatMap(EntitySection::getEntities).filter(entity -> VecHelper.inBounds(entity.blockPosition(), min, max)).map(entity -> new AbstractMap.SimpleEntry<BlockPos, net.minecraft.world.entity.Entity>(entity.blockPosition(), (net.minecraft.world.entity.Entity)entity));
        }
        if (Sponge.isClientAvailable() && chunk.getLevel() instanceof ClientLevel) {
            return ((TransientEntitySectionManagerAccessor)((ClientLevelAccessor)chunk.getLevel()).accessor$getEntityStorage()).accessor$sectionStorage().getExistingSectionsInChunk(SectionPos.of((ChunkPos)chunk.getPos(), (int)0).asLong()).flatMap(EntitySection::getEntities).filter(entity -> VecHelper.inBounds(entity.blockPosition(), min, max)).map(entity -> new AbstractMap.SimpleEntry<BlockPos, net.minecraft.world.entity.Entity>(entity.blockPosition(), (net.minecraft.world.entity.Entity)entity));
        }
        throw new UnsupportedOperationException("Unknown Chunk Level Type");
    }

    public static @NonNull BiConsumer<UUID, net.minecraft.world.entity.Entity> getOrCloneEntityWithVolume(boolean shouldCarbonCopy, @MonotonicNonNull ObjectArrayMutableEntityBuffer backingVolume, Level level) {
        return shouldCarbonCopy ? (pos, entity) -> {
            CompoundTag nbt = new CompoundTag();
            entity.save(nbt);
            @Nullable net.minecraft.world.entity.Entity cloned = entity.getType().create(level);
            Objects.requireNonNull(cloned, () -> String.format("EntityType[%s] creates a null Entity!", EntityType.getKey((EntityType)entity.getType()))).load(nbt);
            backingVolume.spawnEntity((Entity)cloned);
        } : (pos, tile) -> {};
    }

    public static @NonNull BiConsumer<BlockPos, net.minecraft.world.level.block.entity.BlockEntity> getBlockEntityOrCloneToBackingVolume(boolean shouldCarbonCopy, ObjectArrayMutableBlockEntityBuffer backingVolume, @Nullable Level level) {
        return shouldCarbonCopy ? (pos, tile) -> {
            CompoundTag nbt = tile.saveWithFullMetadata();
            BlockState state = tile.getBlockState();
            @Nullable net.minecraft.world.level.block.entity.BlockEntity cloned = tile.getType().create(pos, state);
            Objects.requireNonNull(cloned, () -> String.format("TileEntityType[%s] creates a null TileEntity!", BlockEntityType.getKey((BlockEntityType)tile.getType()))).load(nbt);
            if (level != null) {
                ((BlockEntityAccessor)cloned).accessor$level(level);
            }
            backingVolume.addBlockEntity(pos.getX(), pos.getY(), pos.getZ(), (BlockEntity)cloned);
        } : (pos, tile) -> {};
    }

    public static BiConsumer<BlockPos, BlockState> getOrCopyBlockState(boolean shouldCarbonCopy, ArrayMutableBlockBuffer backingVolume) {
        return (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((BlockPos)pos, (BlockState)blockState);
            }
        };
    }

    public static <R extends Region<R>> BiFunction<BlockPos, R, net.minecraft.util.Tuple<BlockPos, BlockState>> getBlockStateFromThisOrCopiedVolume(boolean shouldCarbonCopy, ArrayMutableBlockBuffer backingVolume) {
        return (blockPos, world) -> {
            BlockState tileEntity = shouldCarbonCopy ? backingVolume.getBlock((BlockPos)blockPos) : ((LevelReader)world).getBlockState(blockPos);
            return new net.minecraft.util.Tuple(blockPos, (Object)tileEntity);
        };
    }

    public static Predicate<net.minecraft.world.entity.Entity> apiToImplPredicate(Predicate<? super net.minecraft.world.entity.Entity> filter) {
        return entity -> entity instanceof net.minecraft.world.entity.Entity && filter.test((net.minecraft.world.entity.Entity)entity);
    }

    public static boolean setBiome(ChunkAccess chunk, int x, int y, int z, Biome biome) {
        boolean result = VolumeStreamUtils.setBiome(chunk.getSection(chunk.getSectionIndex(y)), x, y, z, biome);
        if (result) {
            chunk.setUnsaved(true);
        }
        return result;
    }

    public static boolean setBiome(@Nullable LevelChunkSection section, int x, int y, int z, Biome biome) {
        if (section == null) {
            return false;
        }
        PalettedContainer biomes = section.getBiomes();
        int maskedX = x & 3;
        int maskedY = y & 3;
        int maskedZ = z & 3;
        biomes.set(maskedX, maskedY, maskedZ, (Object)((net.minecraft.world.level.biome.Biome)biome));
        return true;
    }

    private static QuadFunction<ChunkAccess, LevelChunkSection, BlockPos, LevelReader, net.minecraft.world.level.biome.Biome> chunkSectionBiomeGetter() {
        return (chunk, chunkSection, pos, world) -> {
            if (chunk.getSection(chunk.getSectionIndex(pos.getY())) == null) {
                if (chunk instanceof LevelChunk) {
                    return ((LevelChunk)chunk).getLevel().getNoiseBiome(pos.getX(), pos.getY(), pos.getZ());
                }
                return world.getUncachedNoiseBiome(pos.getX(), pos.getY(), pos.getZ());
            }
            return chunk.getNoiseBiome(pos.getX(), pos.getY(), pos.getZ());
        };
    }

    private static TriFunction<ChunkAccess, LevelChunkSection, BlockPos, BlockState> chunkSectionBlockStateGetter() {
        return (chunk, chunkSection, pos) -> chunkSection.getBlockState(pos.getX() - (chunk.getPos().x << 4), pos.getY() & 0xF, pos.getZ() - (chunk.getPos().z << 4));
    }

    private static <T> Function<ChunkAccess, Stream<Map.Entry<BlockPos, T>>> getElementByPosition(TriFunction<ChunkAccess, LevelChunkSection, BlockPos, T> elementAccessor, Vector3i min, Vector3i max) {
        ChunkCursor minCursor = new ChunkCursor(min);
        ChunkCursor maxCursor = new ChunkCursor(max);
        return chunk -> {
            ChunkPos pos = chunk.getPos();
            int xStart = pos.x == minCursor.chunkX ? minCursor.xOffset : 0;
            int xEnd = pos.x == maxCursor.chunkX ? maxCursor.xOffset + 1 : 16;
            int zStart = pos.z == minCursor.chunkZ ? minCursor.zOffset : 0;
            int zEnd = pos.z == maxCursor.chunkZ ? maxCursor.zOffset + 1 : 16;
            int chunkMinX = pos.x << 4;
            int chunkMinZ = pos.z << 4;
            return Arrays.stream(chunk.getSections()).filter(Objects::nonNull).filter(chunkSection -> chunkSection.bottomBlockY() >= minCursor.ySection && chunkSection.bottomBlockY() <= maxCursor.ySection).flatMap(chunkSection -> IntStream.range(zStart, zEnd).mapToObj(z -> IntStream.range(xStart, xEnd).mapToObj(x -> {
                int sectionY = chunkSection.bottomBlockY();
                int yStart = sectionY == minCursor.ySection ? minCursor.yOffset : 0;
                int yEnd = sectionY == maxCursor.ySection ? maxCursor.yOffset + 1 : 16;
                return IntStream.range(yStart, yEnd).mapToObj(y -> {
                    int adjustedX = x + chunkMinX;
                    int adjustedY = y + sectionY;
                    int adjustedZ = z + chunkMinZ;
                    BlockPos blockPos = new BlockPos(adjustedX, adjustedY, adjustedZ);
                    Object apply = Objects.requireNonNull(elementAccessor.apply((ChunkAccess)chunk, (LevelChunkSection)chunkSection, blockPos), "Element cannot be null");
                    return new AbstractMap.SimpleEntry(blockPos, apply);
                });
            })).flatMap(Function.identity()).flatMap(Function.identity()));
        };
    }

    public static <W extends Region<W>> VolumeStream<W, org.spongepowered.api.block.BlockState> generateBlockStream(LevelReader reader, Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(min, max, options, (Region)reader, VolumeStreamUtils.getOrCopyBlockState(shouldCarbonCopy, backingVolume), VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBlockStatesForSections(min, max), VolumeStreamUtils.getBlockStateFromThisOrCopiedVolume(shouldCarbonCopy, backingVolume));
    }

    public static <R extends Region<R>> VolumeStream<R, BlockEntity> getBlockEntityStream(LevelReader reader, Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(min, max, options, (Region)reader, VolumeStreamUtils.getBlockEntityOrCloneToBackingVolume(shouldCarbonCopy, backingVolume, reader instanceof Level ? (Level)reader : null), VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, tileEntity) -> key, chunk -> chunk instanceof LevelChunk ? ((LevelChunk)chunk).getBlockEntities().entrySet().stream().filter(entry -> VecHelper.inBounds((BlockPos)entry.getKey(), min, max)) : Stream.empty(), (blockPos, world) -> {
            @Nullable net.minecraft.world.level.block.entity.BlockEntity tileEntity = shouldCarbonCopy ? backingVolume.getTileEntity((BlockPos)blockPos) : ((LevelReader)world).getBlockEntity(blockPos);
            return new net.minecraft.util.Tuple(blockPos, (Object)tileEntity);
        });
    }

    public static <R extends Region<R>> VolumeStream<R, Biome> getBiomeStream(LevelReader reader, Vector3i min, Vector3i max, StreamOptions options) {
        ObjectArrayMutableBiomeBuffer backingVolume;
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        if (shouldCarbonCopy) {
            net.minecraft.core.Registry biomeRegistry = reader instanceof Level ? (net.minecraft.core.Registry)((Level)reader).registryAccess().registry(net.minecraft.core.Registry.BIOME_REGISTRY).get() : BuiltinRegistries.BIOME;
            backingVolume = new ObjectArrayMutableBiomeBuffer(min, size, VolumeStreamUtils.nativeToSpongeRegistry(biomeRegistry));
        } else {
            backingVolume = null;
        }
        return VolumeStreamUtils.generateStream(min, max, options, (Region)reader, (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((BlockPos)pos, (net.minecraft.world.level.biome.Biome)biome);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus(reader, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBiomesForChunkByPos(reader, min, max), (blockPos, world) -> {
            net.minecraft.world.level.biome.Biome biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.getX(), blockPos.getY(), blockPos.getZ()) : ((LevelReader)world).getBiome(blockPos);
            return new net.minecraft.util.Tuple(blockPos, (Object)biome);
        });
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(Vector3i min, Vector3i max, StreamOptions options, R ref, BiConsumer<KeyReference, MC> identityFunction, BiFunction<R, ChunkPos, Section> chunkAccessor, BiFunction<BlockPos, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiFunction<KeyReference, R, net.minecraft.util.Tuple<BlockPos, MC>> filteredPositionEntityAccessor) {
        Supplier<R> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        BlockPos chunkMin = new BlockPos(min.x() >> 4, 0, min.z() >> 4);
        BlockPos chunkMax = new BlockPos(max.x() >> 4, 0, max.z() >> 4);
        Stream<Object> sectionStream = IntStream.range(chunkMin.getX(), chunkMax.getX() + 1).mapToObj(x -> IntStream.range(chunkMin.getZ(), chunkMax.getZ() + 1).mapToObj(z -> new ChunkPos(x, z))).flatMap(Function.identity()).map(pos -> chunkAccessor.apply(ref, (ChunkPos)pos));
        return VolumeStreamUtils.generateStreamInternal(options, identityFunction, entityToKey, entityAccessor, filteredPositionEntityAccessor, worldSupplier, sectionStream);
    }

    public static <R extends Volume, API, MC, Section, KeyReference> VolumeStream<R, API> generateStream(StreamOptions options, R ref, Section section, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiConsumer<KeyReference, MC> identityFunction, BiFunction<BlockPos, MC, KeyReference> entityToKey, BiFunction<KeyReference, R, net.minecraft.util.Tuple<BlockPos, @Nullable MC>> filteredPositionEntityAccessor) {
        Supplier<R> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(ref, "World");
        Stream<Section> sectionStream = Stream.of(section);
        return VolumeStreamUtils.generateStreamInternal(options, identityFunction, entityToKey, entityAccessor, filteredPositionEntityAccessor, worldSupplier, sectionStream);
    }

    private static <R extends Volume, API, MC, Section, KeyReference> SpongeVolumeStream<R, API> generateStreamInternal(StreamOptions options, BiConsumer<KeyReference, MC> identityFunction, BiFunction<BlockPos, MC, KeyReference> entityToKey, Function<Section, Stream<Map.Entry<BlockPos, MC>>> entityAccessor, BiFunction<KeyReference, R, net.minecraft.util.Tuple<BlockPos, MC>> filteredPositionEntityAccessor, Supplier<R> worldSupplier, Stream<Section> sectionStream) {
        Stream<Object> filteredPosStream;
        Function<net.minecraft.util.Tuple, VolumeElement> elementGenerator = tuple -> {
            Supplier<Object> blockEntitySupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(tuple.getB(), "Element");
            Vector3d blockEntityPos = VecHelper.toVector3d((BlockPos)tuple.getA());
            return VolumeElement.of(worldSupplier, blockEntitySupplier, blockEntityPos);
        };
        BiConsumer<Map.Entry, Set> entryConsumer = (entry, poses) -> {
            BlockPos pos = (BlockPos)entry.getKey();
            Object keyRef = entityToKey.apply(pos, entry.getValue());
            poses.add(keyRef);
            identityFunction.accept(keyRef, entry.getValue());
        };
        if (options.loadingStyle().immediateLoading()) {
            LinkedHashSet availableTileEntityPositions = new LinkedHashSet();
            sectionStream.map(entityAccessor).forEach(map -> map.forEach(entry -> entryConsumer.accept((Map.Entry)entry, availableTileEntityPositions)));
            filteredPosStream = availableTileEntityPositions.stream();
        } else {
            filteredPosStream = sectionStream.flatMap(chunk -> {
                LinkedHashSet blockEntityPoses = new LinkedHashSet();
                ((Stream)entityAccessor.apply(chunk)).forEach(entry -> entryConsumer.accept((Map.Entry)entry, blockEntityPoses));
                return blockEntityPoses.stream();
            });
        }
        Stream volumeStreamBacker = filteredPosStream.map(pos -> (net.minecraft.util.Tuple)filteredPositionEntityAccessor.apply(pos, (Volume)worldSupplier.get())).filter(Objects::nonNull).filter(tuple -> Objects.nonNull(tuple.getB())).map(elementGenerator);
        return new SpongeVolumeStream(volumeStreamBacker, worldSupplier);
    }

    public static interface QuadFunction<A, B, C, D, Out> {
        public Out apply(A var1, B var2, C var3, D var4);

        default public TriFunction<A, B, C, Out> asTri(D d) {
            Supplier<D> dSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(d, "D");
            return (a, b, c) -> this.apply(a, b, c, dSupplier.get());
        }
    }

    public static interface TriFunction<A, B, C, Out> {
        public Out apply(A var1, B var2, C var3);
    }
}

