/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ObjectArrayMutableEntityBuffer
extends AbstractBlockBuffer
implements EntityVolume.Mutable {
    private final ArrayMutableBlockBuffer blockBuffer;
    private final List<Entity> entities;

    public ObjectArrayMutableEntityBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.blockBuffer = new ArrayMutableBlockBuffer(start, size);
        this.entities = new ArrayList<Entity>();
    }

    public ObjectArrayMutableEntityBuffer(Vector3i start, Vector3i size, ArrayMutableBlockBuffer blockBuffer) {
        super(start, size);
        this.blockBuffer = blockBuffer;
        this.entities = new ArrayList<Entity>();
    }

    @Override
    public Palette<BlockState, BlockType> getPalette() {
        return this.blockBuffer.getPalette();
    }

    @Override
    public BlockState block(int x, int y, int z) {
        return this.blockBuffer.block(x, y, z);
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.blockBuffer.fluid(x, y, z);
    }

    @Override
    public int highestYAt(int x, int z) {
        return this.blockBuffer.highestYAt(x, z);
    }

    @Override
    public VolumeStream<EntityVolume.Mutable, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.blockBuffer.copy() : this.blockBuffer;
        Stream stateStream = IntStream.range(min.x(), max.x() + 1).mapToObj(x -> IntStream.range(min.z(), max.z() + 1).mapToObj(z -> IntStream.range(min.y(), max.y() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer.block(x, y, z), new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<EntityVolume.Mutable, BlockState>(stateStream, () -> this);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.blockBuffer.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.blockBuffer.removeBlock(x, y, z);
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Cannot create entities without a world, can only add to a volume");
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Cannot create entities without a world, can only add to a volume");
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer) {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        return Optional.empty();
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null!");
        }
        if (!this.contains(entity.position().toInt())) {
            throw new IllegalArgumentException(String.format("Entity is out of bounds! {min: %s, max: %s} does not contain %s", this.min(), this.max(), entity.position()));
        }
        return this.entities.add(entity);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return StreamSupport.stream(entities.spliterator(), false).filter(this::spawnEntity).collect(Collectors.toList());
    }

    @Override
    public Collection<? extends Player> players() {
        return this.entities.stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).collect(Collectors.toList());
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("UUID cannot be null!");
        }
        return this.entities.stream().filter(entity -> uuid.equals(entity.uniqueId())).findFirst();
    }

    @Override
    public Collection<? extends Entity> entities() {
        return ImmutableList.copyOf(this.entities);
    }

    @Override
    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        Objects.requireNonNull(entityClass);
        Objects.requireNonNull(box);
        if (!this.contains(box.min().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed");
        }
        if (!this.contains(box.max().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed!");
        }
        Stream<Entity> tStream = this.entities.stream().filter(entityClass::isInstance).map(entity -> entity).filter(entity -> box.contains(entity.position()));
        if (predicate != null) {
            tStream = tStream.filter(predicate);
        }
        return tStream.collect(Collectors.toList());
    }

    @Override
    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        Objects.requireNonNull(filter, "Filter cannot be null");
        Objects.requireNonNull(box, "Bounding box cannot be null");
        if (!this.contains(box.min().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed");
        }
        if (!this.contains(box.max().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed!");
        }
        return this.entities.stream().filter(entity -> box.contains(entity.position())).filter(filter).collect(Collectors.toList());
    }

    @Override
    public VolumeStream<EntityVolume.Mutable, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        Stream backingStream = this.entities.stream().map(entity -> VolumeElement.of(this, entity, entity.position()));
        return new SpongeVolumeStream<EntityVolume.Mutable, Entity>(backingStream, () -> this);
    }
}

