/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.filter.type.Include;
import org.spongepowered.plugin.processor.ListenerParameterAnnotation;
import org.spongepowered.plugin.processor.ParameterContext;
import org.spongepowered.plugin.processor.ProcessorUtils;

@SupportedAnnotationTypes(value={"org.spongepowered.api.event.Listener"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_16)
public class ListenerProcessor
extends AbstractProcessor {
    static final String LISTENER_ANNOTATION_CLASS = "org.spongepowered.api.event.Listener";
    private static final String EVENT_CLASS = Event.class.getName();
    private static final String IS_CANCELLED_ANNOTATION = IsCancelled.class.getName();
    private static final String INCLUDE_ANNOTATION = Include.class.getName();
    private static final String EXCLUDE_ANNOTATION = Exclude.class.getName();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>(super.getSupportedAnnotationTypes());
        for (ListenerParameterAnnotation annotation : ListenerParameterAnnotation.values()) {
            types.add(annotation.className());
        }
        return Collections.unmodifiableSet(types);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (ProcessorUtils.contains(annotations, Listener.class)) {
            for (Element element : roundEnv.getElementsAnnotatedWith(Listener.class)) {
                void var10_10;
                DeclaredType eventType;
                List<? extends VariableElement> parameters;
                if (element.getKind() != ElementKind.METHOD) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid element of type " + element.getKind() + " annotated with @Listener", element);
                    continue;
                }
                ExecutableElement method = (ExecutableElement)element;
                if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.error("Event listener method must not be static", method);
                }
                if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    this.error("Event listener method must not be abstract", method);
                }
                if (method.getEnclosingElement().getKind().isInterface()) {
                    this.error("interfaces cannot declare listeners", method);
                }
                if (method.getReturnType().getKind() != TypeKind.VOID) {
                    this.error("Event listener method must return void", method);
                }
                if ((parameters = method.getParameters()).isEmpty() || !this.isTypeSubclass(parameters.get(0), EVENT_CLASS)) {
                    this.error("Event listener method must have an Event as its first parameter", method);
                    eventType = null;
                } else {
                    eventType = (DeclaredType)parameters.get(0).asType();
                }
                Types types = this.processingEnv.getTypeUtils();
                if (eventType != null) {
                    for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                        String name = this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).toString();
                        if (name.equals(IS_CANCELLED_ANNOTATION)) {
                            TypeElement cancellable = this.processingEnv.getElementUtils().getTypeElement("org.spongepowered.api.event.Cancellable");
                            if (cancellable == null || types.isAssignable(eventType, cancellable.asType())) continue;
                            this.error("A listener for a non-Cancellable method cannot be annotated with @IsCancelled", method);
                            continue;
                        }
                        if (!name.equals(INCLUDE_ANNOTATION) && !name.equals(EXCLUDE_ANNOTATION)) continue;
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                            if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                            List values = (List)entry.getValue().getValue();
                            for (AnnotationValue subtype : values) {
                                if (types.isAssignable((TypeMirror)subtype.getValue(), eventType)) continue;
                                this.error("All filtered types must be subtypes of the event type '" + eventType.asElement().getSimpleName() + "'", method, annotationMirror, subtype);
                            }
                        }
                    }
                }
                ParameterContext ctx = new ParameterContext(this.processingEnv, eventType);
                boolean bl = true;
                while (var10_10 < parameters.size()) {
                    this.checkParameter(ctx, parameters.get((int)var10_10));
                    ++var10_10;
                }
            }
        }
        return false;
    }

    private void checkParameter(ParameterContext ctx, VariableElement element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ctx.init(element, annotationMirror);
            Name name = this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement());
            ListenerParameterAnnotation anno = ListenerParameterAnnotation.byClassName(name.toString());
            if (anno == null) continue;
            anno.validate(ctx);
        }
    }

    private boolean isTypeSubclass(Element typedElement, String subclass) {
        Elements elements = this.processingEnv.getElementUtils();
        Types types = this.processingEnv.getTypeUtils();
        DeclaredType event = types.getDeclaredType(elements.getTypeElement(subclass), new TypeMirror[0]);
        return types.isAssignable(typedElement.asType(), event);
    }

    private void error(CharSequence message, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private void error(CharSequence message, Element element, AnnotationMirror annotation, AnnotationValue value) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element, annotation, value);
    }
}

