/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.util;

import org.apache.logging.log4j.Level;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.util.PrettyPrinter;

public final class Java8SpaceDetection {
    public static void check() {
        String location;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.") && ((location = Java8SpaceDetection.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm()).contains(" ") || location.contains("%20"))) {
            new PrettyPrinter(100).add("UNABLE TO START SPONGE - SPACE IN PATH RUNNING ON JAVA 8").centre().hr().add("We have detected the following situation where Sponge is unable to load:").add().add("* You are running Java 8; and").add("* You have placed Sponge in a folder that has a space in its name (or one of its parent folders does); or").add("* Your Sponge jar file has a space in its name.").add().add("To allow Sponge to run, do ONE of the following:").add().add("* Upgrade your version of Java to at least version 9 (though we recommend Java 17); or").add("* Make sure that the names of your Sponge jar and all parent folders do not contain any spaces.").add().add("Once you have done one of the above, try again.").hr().add("Technical Details:").add("* Detected Java Version: %s", javaVersion).add("* Detected JAR location: %s", location).log(AppLaunch.logger(), Level.FATAL);
            System.exit(1);
        }
    }
}

