/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tinylog.Logger;

public final class InstallerUtils {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private InstallerUtils() {
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean validateSha1(String expectedHash, Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl = InstallerUtils.validateSha1(expectedHash, is);
            return bl;
        }
    }

    public static boolean validateSha1(String expectedHash, InputStream stream) throws IOException {
        int read;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)ex);
        }
        byte[] buf = new byte[4096];
        while ((read = stream.read(buf)) != -1) {
            digest.update(buf, 0, read);
        }
        return expectedHash.equals(InstallerUtils.toHexString(digest.digest()));
    }

    public static boolean validateSha256(String expectedHash, Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl = InstallerUtils.validateSha256(expectedHash, is);
            return bl;
        }
    }

    public static boolean validateSha256(String expectedHash, InputStream stream) throws IOException {
        int read;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)ex);
        }
        byte[] buf = new byte[4096];
        while ((read = stream.read(buf)) != -1) {
            digest.update(buf, 0, read);
        }
        return expectedHash.equals(InstallerUtils.toHexString(digest.digest()));
    }

    public static void download(URL url, Path path, boolean requiresRequest) throws IOException {
        block25: {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String name = path.getFileName().toString();
            Logger.info("Downloading {}. This may take a while...", name);
            Logger.info("URL -> <{}>", url);
            if (!requiresRequest) {
                try (ReadableByteChannel in = Channels.newChannel(url.openStream());
                     FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    out.transferFrom(in, 0L, Long.MAX_VALUE);
                    break block25;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Sponge-Downloader");
            connection.connect();
            try (ReadableByteChannel in = Channels.newChannel(connection.getInputStream());
                 FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                out.transferFrom(in, 0L, Long.MAX_VALUE);
            }
        }
    }

    public static void downloadCheckHash(URL url, Path path, MessageDigest digest, String expected) throws IOException {
        String name = path.getFileName().toString();
        Logger.info("Downloading {}. This may take a while...", name);
        Logger.debug("URL -> <{}>", url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Sponge-Downloader");
        connection.connect();
        try (InputStream is = connection.getInputStream();){
            InstallerUtils.transferCheckHash(is, path, digest, expected);
        }
    }

    public static void transferCheckHash(InputStream source, Path path, MessageDigest digest, String expected) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        String name = path.getFileName().toString();
        try (DigestInputStream stream = new DigestInputStream(source, digest);
             ReadableByteChannel in = Channels.newChannel(stream);
             FileChannel out = FileChannel.open(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            out.transferFrom(in, 0L, Long.MAX_VALUE);
        }
        String fileSha1 = InstallerUtils.toHexString(digest.digest());
        if (!expected.equalsIgnoreCase(fileSha1)) {
            Files.delete(path);
            throw new IOException(String.format("Checksum verification for %s failed: Expected '%s', got '%s'.", name, expected, fileSha1));
        }
        Logger.info("Successfully processed {} and verified checksum!", name);
    }
}

