/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.Expose;
import com.velocitypowered.api.proxy.config.ProxyConfig;
import com.velocitypowered.api.util.Favicon;
import com.velocitypowered.proxy.config.PingPassthroughMode;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.util.AddressUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityConfiguration
implements ProxyConfig {
    private static final Logger logger = LogManager.getLogger(VelocityConfiguration.class);
    @Expose
    private String bind = "0.0.0.0:25577";
    @Expose
    private String motd = "&3A Velocity Server";
    @Expose
    private int showMaxPlayers = 500;
    @Expose
    private boolean onlineMode = true;
    @Expose
    private boolean preventClientProxyConnections = false;
    @Expose
    private PlayerInfoForwarding playerInfoForwardingMode = PlayerInfoForwarding.NONE;
    private byte[] forwardingSecret = VelocityConfiguration.generateRandomString(12).getBytes(StandardCharsets.UTF_8);
    @Expose
    private boolean announceForge = false;
    @Expose
    private boolean onlineModeKickExistingPlayers = false;
    @Expose
    private PingPassthroughMode pingPassthrough = PingPassthroughMode.DISABLED;
    private final Servers servers;
    private final ForcedHosts forcedHosts;
    @Expose
    private final Advanced advanced;
    @Expose
    private final Query query;
    private final Metrics metrics;
    @Expose
    private boolean enablePlayerAddressLogging = true;
    private @MonotonicNonNull Component motdAsComponent;
    private @Nullable Favicon favicon;
    @Expose
    private boolean forceKeyAuthentication = true;

    private VelocityConfiguration(Servers servers, ForcedHosts forcedHosts, Advanced advanced, Query query, Metrics metrics) {
        this.servers = servers;
        this.forcedHosts = forcedHosts;
        this.advanced = advanced;
        this.query = query;
        this.metrics = metrics;
    }

    private VelocityConfiguration(String bind, String motd, int showMaxPlayers, boolean onlineMode, boolean preventClientProxyConnections, boolean announceForge, PlayerInfoForwarding playerInfoForwardingMode, byte[] forwardingSecret, boolean onlineModeKickExistingPlayers, PingPassthroughMode pingPassthrough, boolean enablePlayerAddressLogging, Servers servers, ForcedHosts forcedHosts, Advanced advanced, Query query, Metrics metrics, boolean forceKeyAuthentication) {
        this.bind = bind;
        this.motd = motd;
        this.showMaxPlayers = showMaxPlayers;
        this.onlineMode = onlineMode;
        this.preventClientProxyConnections = preventClientProxyConnections;
        this.announceForge = announceForge;
        this.playerInfoForwardingMode = playerInfoForwardingMode;
        this.forwardingSecret = forwardingSecret;
        this.onlineModeKickExistingPlayers = onlineModeKickExistingPlayers;
        this.pingPassthrough = pingPassthrough;
        this.enablePlayerAddressLogging = enablePlayerAddressLogging;
        this.servers = servers;
        this.forcedHosts = forcedHosts;
        this.advanced = advanced;
        this.query = query;
        this.metrics = metrics;
        this.forceKeyAuthentication = forceKeyAuthentication;
    }

    public boolean validate() {
        boolean valid = true;
        if (this.bind.isEmpty()) {
            logger.error("'bind' option is empty.");
            valid = false;
        } else {
            try {
                AddressUtil.parseAddress(this.bind);
            }
            catch (IllegalArgumentException e) {
                logger.error("'bind' option does not specify a valid IP address.", (Throwable)e);
                valid = false;
            }
        }
        if (!this.onlineMode) {
            logger.warn("The proxy is running in offline mode! This is a security risk and you will NOT receive any support!");
        }
        switch (this.playerInfoForwardingMode) {
            case NONE: {
                logger.warn("Player info forwarding is disabled! All players will appear to be connecting from the proxy and will have offline-mode UUIDs.");
                break;
            }
            case MODERN: 
            case BUNGEEGUARD: {
                if (this.forwardingSecret != null && this.forwardingSecret.length != 0) break;
                logger.error("You don't have a forwarding secret set. This is required for security.");
                valid = false;
                break;
            }
        }
        if (this.servers.getServers().isEmpty()) {
            logger.warn("You don't have any servers configured.");
        }
        for (Map.Entry<String, String> entry : this.servers.getServers().entrySet()) {
            try {
                AddressUtil.parseAddress(entry.getValue());
            }
            catch (IllegalArgumentException e) {
                logger.error("Server {} does not have a valid IP address.", (Object)entry.getKey(), (Object)e);
                valid = false;
            }
        }
        for (String string : this.servers.getAttemptConnectionOrder()) {
            if (this.servers.getServers().containsKey(string)) continue;
            logger.error("Fallback server " + string + " is not registered in your configuration!");
            valid = false;
        }
        for (Map.Entry entry : this.forcedHosts.getForcedHosts().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                logger.error("Forced host '{}' does not contain any servers", entry.getKey());
                valid = false;
                continue;
            }
            for (String server : (List)entry.getValue()) {
                if (this.servers.getServers().containsKey(server)) continue;
                logger.error("Server '{}' for forced host '{}' does not exist", (Object)server, entry.getKey());
                valid = false;
            }
        }
        try {
            this.getMotd();
        }
        catch (Exception e) {
            logger.error("Can't parse your MOTD", (Throwable)e);
            valid = false;
        }
        if (this.advanced.compressionLevel < -1 || this.advanced.compressionLevel > 9) {
            logger.error("Invalid compression level {}", (Object)this.advanced.compressionLevel);
            valid = false;
        } else if (this.advanced.compressionLevel == 0) {
            logger.warn("ALL packets going through the proxy will be uncompressed. This will increase bandwidth usage.");
        }
        if (this.advanced.compressionThreshold < -1) {
            logger.error("Invalid compression threshold {}", (Object)this.advanced.compressionLevel);
            valid = false;
        } else if (this.advanced.compressionThreshold == 0) {
            logger.warn("ALL packets going through the proxy will be compressed. This will compromise throughput and increase CPU usage!");
        }
        if (this.advanced.loginRatelimit < 0) {
            logger.error("Invalid login ratelimit {}ms", (Object)this.advanced.loginRatelimit);
            valid = false;
        }
        this.loadFavicon();
        return valid;
    }

    private void loadFavicon() {
        Path faviconPath = Path.of("server-icon.png", new String[0]);
        if (Files.exists(faviconPath, new LinkOption[0])) {
            try {
                this.favicon = Favicon.create(faviconPath);
            }
            catch (Exception e) {
                logger.info("Unable to load your server-icon.png, continuing without it.", (Throwable)e);
            }
        }
    }

    public InetSocketAddress getBind() {
        return AddressUtil.parseAndResolveAddress(this.bind);
    }

    @Override
    public boolean isQueryEnabled() {
        return this.query.isQueryEnabled();
    }

    @Override
    public int getQueryPort() {
        return this.query.getQueryPort();
    }

    @Override
    public String getQueryMap() {
        return this.query.getQueryMap();
    }

    @Override
    public boolean shouldQueryShowPlugins() {
        return this.query.shouldQueryShowPlugins();
    }

    @Override
    public Component getMotd() {
        if (this.motdAsComponent == null) {
            this.motdAsComponent = this.motd.startsWith("{") ? GsonComponentSerializer.gson().deserialize(this.motd) : LegacyComponentSerializer.legacy('&').deserialize(this.motd);
        }
        return this.motdAsComponent;
    }

    @Override
    public int getShowMaxPlayers() {
        return this.showMaxPlayers;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public boolean shouldPreventClientProxyConnections() {
        return this.preventClientProxyConnections;
    }

    public PlayerInfoForwarding getPlayerInfoForwardingMode() {
        return this.playerInfoForwardingMode;
    }

    public byte[] getForwardingSecret() {
        return (byte[])this.forwardingSecret.clone();
    }

    @Override
    public Map<String, String> getServers() {
        return this.servers.getServers();
    }

    @Override
    public List<String> getAttemptConnectionOrder() {
        return this.servers.getAttemptConnectionOrder();
    }

    @Override
    public Map<String, List<String>> getForcedHosts() {
        return this.forcedHosts.getForcedHosts();
    }

    @Override
    public int getCompressionThreshold() {
        return this.advanced.getCompressionThreshold();
    }

    @Override
    public int getCompressionLevel() {
        return this.advanced.getCompressionLevel();
    }

    @Override
    public int getLoginRatelimit() {
        return this.advanced.getLoginRatelimit();
    }

    @Override
    public Optional<Favicon> getFavicon() {
        return Optional.ofNullable(this.favicon);
    }

    @Override
    public boolean isAnnounceForge() {
        return this.announceForge;
    }

    @Override
    public int getConnectTimeout() {
        return this.advanced.getConnectionTimeout();
    }

    @Override
    public int getReadTimeout() {
        return this.advanced.getReadTimeout();
    }

    public boolean isProxyProtocol() {
        return this.advanced.isProxyProtocol();
    }

    public boolean useTcpFastOpen() {
        return this.advanced.tcpFastOpen;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PingPassthroughMode getPingPassthrough() {
        return this.pingPassthrough;
    }

    public boolean isPlayerAddressLoggingEnabled() {
        return this.enablePlayerAddressLogging;
    }

    public boolean isBungeePluginChannelEnabled() {
        return this.advanced.isBungeePluginMessageChannel();
    }

    public boolean isShowPingRequests() {
        return this.advanced.isShowPingRequests();
    }

    public boolean isFailoverOnUnexpectedServerDisconnect() {
        return this.advanced.isFailoverOnUnexpectedServerDisconnect();
    }

    public boolean isAnnounceProxyCommands() {
        return this.advanced.isAnnounceProxyCommands();
    }

    public boolean isLogCommandExecutions() {
        return this.advanced.isLogCommandExecutions();
    }

    public boolean isLogPlayerConnections() {
        return this.advanced.isLogPlayerConnections();
    }

    public boolean isForceKeyAuthentication() {
        return this.forceKeyAuthentication;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bind", this.bind).add("motd", this.motd).add("showMaxPlayers", this.showMaxPlayers).add("onlineMode", this.onlineMode).add("playerInfoForwardingMode", (Object)this.playerInfoForwardingMode).add("forwardingSecret", this.forwardingSecret).add("announceForge", this.announceForge).add("servers", this.servers).add("forcedHosts", this.forcedHosts).add("advanced", this.advanced).add("query", this.query).add("favicon", this.favicon).add("enablePlayerAddressLogging", this.enablePlayerAddressLogging).add("forceKeyAuthentication", this.forceKeyAuthentication).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="I looked carefully and there's no way SpotBugs is right.")
    public static VelocityConfiguration read(Path path) throws IOException {
        String forwardingSecretString;
        boolean legacyConfig;
        double configVersion;
        URL defaultConfigLocation = VelocityConfiguration.class.getClassLoader().getResource("default-velocity.toml");
        if (defaultConfigLocation == null) {
            throw new RuntimeException("Default configuration file does not exist.");
        }
        Path defaultForwardingSecretPath = Path.of("forwarding.secret", new String[0]);
        if (Files.notExists(path, new LinkOption[0]) && Files.notExists(defaultForwardingSecretPath, new LinkOption[0])) {
            Files.writeString(defaultForwardingSecretPath, (CharSequence)VelocityConfiguration.generateRandomString(12), new OpenOption[0]);
        }
        boolean mustResave = false;
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(path).defaultData(defaultConfigLocation).autosave().preserveInsertionOrder().sync().build();
        config.load();
        File tmpFile = File.createTempFile("default-config", null);
        tmpFile.deleteOnExit();
        try (InputStream in = defaultConfigLocation.openStream();){
            Files.copy(in, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        CommentedFileConfig defaultConfig = CommentedFileConfig.of(tmpFile, (ConfigFormat<? extends CommentedConfig>)TomlFormat.instance());
        defaultConfig.load();
        try {
            configVersion = Double.parseDouble(config.getOrElse("config-version", "1.0"));
        }
        catch (NumberFormatException e) {
            configVersion = 1.0;
        }
        boolean bl = legacyConfig = configVersion < 2.0;
        if (legacyConfig) {
            logger.warn("You are currently using a deprecated configuration version. The \"forwarding-secret\" parameter has been recognized as a security concern and has been removed in config version 2.0. It's recommended you rename your current \"velocity.toml\" to something else to allow Velocity to generate a config file of the new version. You may then configure that file as you normally would. The only differences are the config-version and \"forwarding-secret\" has been replaced by \"forwarding-secret-file\".");
            forwardingSecretString = System.getenv().getOrDefault("VELOCITY_FORWARDING_SECRET", (String)config.get("forwarding-secret"));
            if (forwardingSecretString == null || forwardingSecretString.isEmpty()) {
                forwardingSecretString = VelocityConfiguration.generateRandomString(12);
                config.set("forwarding-secret", (Object)forwardingSecretString);
                mustResave = true;
            }
        } else {
            forwardingSecretString = System.getenv().getOrDefault("VELOCITY_FORWARDING_SECRET", "");
            if (forwardingSecretString.isEmpty()) {
                Path secretPath;
                String forwardSecretFile = (String)config.get("forwarding-secret-file");
                Path path2 = secretPath = forwardSecretFile == null ? defaultForwardingSecretPath : Path.of(forwardSecretFile, new String[0]);
                if (!Files.exists(secretPath, new LinkOption[0])) throw new RuntimeException("The forwarding-secret-file does not exists.");
                if (!Files.isRegularFile(secretPath, new LinkOption[0])) throw new RuntimeException("The file " + forwardSecretFile + " is not a valid file or it is a directory.");
                forwardingSecretString = String.join((CharSequence)"", Files.readAllLines(secretPath));
            }
        }
        byte[] forwardingSecret = forwardingSecretString.getBytes(StandardCharsets.UTF_8);
        if (configVersion == 1.0 || configVersion == 2.0) {
            config.set("force-key-authentication", (Object)config.getOrElse("force-key-authentication", Boolean.valueOf(true)));
            config.setComment("force-key-authentication", "Should the proxy enforce the new public key security standard? By default, this is on.");
            config.set("config-version", (Object)(configVersion == 2.0 ? "2.5" : "1.5"));
            mustResave = true;
        }
        if (mustResave) {
            config.save();
        }
        CommentedConfig serversConfig = (CommentedConfig)config.get("servers");
        CommentedConfig forcedHostsConfig = (CommentedConfig)config.get("forced-hosts");
        CommentedConfig advancedConfig = (CommentedConfig)config.get("advanced");
        CommentedConfig queryConfig = (CommentedConfig)config.get("query");
        CommentedConfig metricsConfig = (CommentedConfig)config.get("metrics");
        PlayerInfoForwarding forwardingMode = config.getEnumOrElse("player-info-forwarding-mode", PlayerInfoForwarding.NONE);
        PingPassthroughMode pingPassthroughMode = config.getEnumOrElse("ping-passthrough", PingPassthroughMode.DISABLED);
        String bind = config.getOrElse("bind", "0.0.0.0:25577");
        String motd = config.getOrElse("motd", "&#09add3A Velocity Server");
        int maxPlayers = config.getIntOrElse("show-max-players", 500);
        Boolean onlineMode = config.getOrElse("online-mode", Boolean.valueOf(true));
        Boolean forceKeyAuthentication = config.getOrElse("force-key-authentication", Boolean.valueOf(true));
        Boolean announceForge = config.getOrElse("announce-forge", Boolean.valueOf(true));
        Boolean preventClientProxyConnections = config.getOrElse("prevent-client-proxy-connections", Boolean.valueOf(true));
        Boolean kickExisting = config.getOrElse("kick-existing-players", Boolean.valueOf(false));
        Boolean enablePlayerAddressLogging = config.getOrElse("enable-player-address-logging", Boolean.valueOf(true));
        if (forwardingSecret.length != 0 || forwardingMode != PlayerInfoForwarding.MODERN && forwardingMode != PlayerInfoForwarding.BUNGEEGUARD) return new VelocityConfiguration(bind, motd, maxPlayers, onlineMode, preventClientProxyConnections, announceForge, forwardingMode, forwardingSecret, kickExisting, pingPassthroughMode, enablePlayerAddressLogging, new Servers(serversConfig), new ForcedHosts(forcedHostsConfig), new Advanced(advancedConfig), new Query(queryConfig), new Metrics(metricsConfig), forceKeyAuthentication);
        throw new RuntimeException("The forwarding-secret file must not be empty.");
    }

    private static String generateRandomString(int length) {
        String chars = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890";
        StringBuilder builder = new StringBuilder();
        SecureRandom rnd = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            builder.append(chars.charAt(rnd.nextInt(chars.length())));
        }
        return builder.toString();
    }

    public boolean isOnlineModeKickExistingPlayers() {
        return this.onlineModeKickExistingPlayers;
    }

    public static class Metrics {
        private boolean enabled = true;

        private Metrics(CommentedConfig toml) {
            if (toml != null) {
                this.enabled = toml.getOrElse("enabled", Boolean.valueOf(true));
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private static class Query {
        @Expose
        private boolean queryEnabled = false;
        @Expose
        private int queryPort = 25577;
        @Expose
        private String queryMap = "Velocity";
        @Expose
        private boolean showPlugins = false;

        private Query() {
        }

        private Query(boolean queryEnabled, int queryPort, String queryMap, boolean showPlugins) {
            this.queryEnabled = queryEnabled;
            this.queryPort = queryPort;
            this.queryMap = queryMap;
            this.showPlugins = showPlugins;
        }

        private Query(CommentedConfig config) {
            if (config != null) {
                this.queryEnabled = config.getOrElse("enabled", Boolean.valueOf(false));
                this.queryPort = config.getIntOrElse("port", 25577);
                this.queryMap = config.getOrElse("map", "Velocity");
                this.showPlugins = config.getOrElse("show-plugins", Boolean.valueOf(false));
            }
        }

        public boolean isQueryEnabled() {
            return this.queryEnabled;
        }

        public int getQueryPort() {
            return this.queryPort;
        }

        public String getQueryMap() {
            return this.queryMap;
        }

        public boolean shouldQueryShowPlugins() {
            return this.showPlugins;
        }

        public String toString() {
            return "Query{queryEnabled=" + this.queryEnabled + ", queryPort=" + this.queryPort + ", queryMap='" + this.queryMap + "', showPlugins=" + this.showPlugins + "}";
        }
    }

    private static class Advanced {
        @Expose
        private int compressionThreshold = 256;
        @Expose
        private int compressionLevel = -1;
        @Expose
        private int loginRatelimit = 3000;
        @Expose
        private int connectionTimeout = 5000;
        @Expose
        private int readTimeout = 30000;
        @Expose
        private boolean proxyProtocol = false;
        @Expose
        private boolean tcpFastOpen = false;
        @Expose
        private boolean bungeePluginMessageChannel = true;
        @Expose
        private boolean showPingRequests = false;
        @Expose
        private boolean failoverOnUnexpectedServerDisconnect = true;
        @Expose
        private boolean announceProxyCommands = true;
        @Expose
        private boolean logCommandExecutions = false;
        @Expose
        private boolean logPlayerConnections = true;

        private Advanced() {
        }

        private Advanced(CommentedConfig config) {
            if (config != null) {
                this.compressionThreshold = config.getIntOrElse("compression-threshold", 256);
                this.compressionLevel = config.getIntOrElse("compression-level", -1);
                this.loginRatelimit = config.getIntOrElse("login-ratelimit", 3000);
                this.connectionTimeout = config.getIntOrElse("connection-timeout", 5000);
                this.readTimeout = config.getIntOrElse("read-timeout", 30000);
                this.proxyProtocol = config.contains("haproxy-protocol") ? config.getOrElse("haproxy-protocol", Boolean.valueOf(false)).booleanValue() : config.getOrElse("proxy-protocol", Boolean.valueOf(false)).booleanValue();
                this.tcpFastOpen = config.getOrElse("tcp-fast-open", Boolean.valueOf(false));
                this.bungeePluginMessageChannel = config.getOrElse("bungee-plugin-message-channel", Boolean.valueOf(true));
                this.showPingRequests = config.getOrElse("show-ping-requests", Boolean.valueOf(false));
                this.failoverOnUnexpectedServerDisconnect = config.getOrElse("failover-on-unexpected-server-disconnect", Boolean.valueOf(true));
                this.announceProxyCommands = config.getOrElse("announce-proxy-commands", Boolean.valueOf(true));
                this.logCommandExecutions = config.getOrElse("log-command-executions", Boolean.valueOf(false));
                this.logPlayerConnections = config.getOrElse("log-player-connections", Boolean.valueOf(true));
            }
        }

        public int getCompressionThreshold() {
            return this.compressionThreshold;
        }

        public int getCompressionLevel() {
            return this.compressionLevel;
        }

        public int getLoginRatelimit() {
            return this.loginRatelimit;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public boolean isProxyProtocol() {
            return this.proxyProtocol;
        }

        public boolean isTcpFastOpen() {
            return this.tcpFastOpen;
        }

        public boolean isBungeePluginMessageChannel() {
            return this.bungeePluginMessageChannel;
        }

        public boolean isShowPingRequests() {
            return this.showPingRequests;
        }

        public boolean isFailoverOnUnexpectedServerDisconnect() {
            return this.failoverOnUnexpectedServerDisconnect;
        }

        public boolean isAnnounceProxyCommands() {
            return this.announceProxyCommands;
        }

        public boolean isLogCommandExecutions() {
            return this.logCommandExecutions;
        }

        public boolean isLogPlayerConnections() {
            return this.logPlayerConnections;
        }

        public String toString() {
            return "Advanced{compressionThreshold=" + this.compressionThreshold + ", compressionLevel=" + this.compressionLevel + ", loginRatelimit=" + this.loginRatelimit + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", proxyProtocol=" + this.proxyProtocol + ", tcpFastOpen=" + this.tcpFastOpen + ", bungeePluginMessageChannel=" + this.bungeePluginMessageChannel + ", showPingRequests=" + this.showPingRequests + ", failoverOnUnexpectedServerDisconnect=" + this.failoverOnUnexpectedServerDisconnect + ", announceProxyCommands=" + this.announceProxyCommands + ", logCommandExecutions=" + this.logCommandExecutions + ", logPlayerConnections=" + this.logPlayerConnections + "}";
        }
    }

    private static class ForcedHosts {
        private Map<String, List<String>> forcedHosts = ImmutableMap.of("lobby.example.com", ImmutableList.of("lobby"), "factions.example.com", ImmutableList.of("factions"), "minigames.example.com", ImmutableList.of("minigames"));

        private ForcedHosts() {
        }

        private ForcedHosts(CommentedConfig config) {
            if (config != null) {
                HashMap forcedHosts = new HashMap();
                for (UnmodifiableConfig.Entry entry : config.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        forcedHosts.put(entry.getKey().toLowerCase(Locale.ROOT), ImmutableList.of((String)entry.getValue()));
                        continue;
                    }
                    if (entry.getValue() instanceof List) {
                        forcedHosts.put(entry.getKey().toLowerCase(Locale.ROOT), ImmutableList.copyOf((List)entry.getValue()));
                        continue;
                    }
                    throw new IllegalStateException("Invalid value of type " + entry.getValue().getClass() + " in forced hosts!");
                }
                this.forcedHosts = ImmutableMap.copyOf(forcedHosts);
            }
        }

        private ForcedHosts(Map<String, List<String>> forcedHosts) {
            this.forcedHosts = forcedHosts;
        }

        private Map<String, List<String>> getForcedHosts() {
            return this.forcedHosts;
        }

        private void setForcedHosts(Map<String, List<String>> forcedHosts) {
            this.forcedHosts = forcedHosts;
        }

        public String toString() {
            return "ForcedHosts{forcedHosts=" + this.forcedHosts + "}";
        }
    }

    private static class Servers {
        private Map<String, String> servers = ImmutableMap.of("lobby", "127.0.0.1:30066", "factions", "127.0.0.1:30067", "minigames", "127.0.0.1:30068");
        private List<String> attemptConnectionOrder = ImmutableList.of("lobby");

        private Servers() {
        }

        private Servers(CommentedConfig config) {
            if (config != null) {
                HashMap<String, String> servers = new HashMap<String, String>();
                for (UnmodifiableConfig.Entry entry : config.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        servers.put(this.cleanServerName(entry.getKey()), (String)entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equalsIgnoreCase("try")) continue;
                    throw new IllegalArgumentException("Server entry " + entry.getKey() + " is not a string!");
                }
                this.servers = ImmutableMap.copyOf(servers);
                this.attemptConnectionOrder = config.getOrElse("try", this.attemptConnectionOrder);
            }
        }

        private Servers(Map<String, String> servers, List<String> attemptConnectionOrder) {
            this.servers = servers;
            this.attemptConnectionOrder = attemptConnectionOrder;
        }

        private Map<String, String> getServers() {
            return this.servers;
        }

        public void setServers(Map<String, String> servers) {
            this.servers = servers;
        }

        public List<String> getAttemptConnectionOrder() {
            return this.attemptConnectionOrder;
        }

        public void setAttemptConnectionOrder(List<String> attemptConnectionOrder) {
            this.attemptConnectionOrder = attemptConnectionOrder;
        }

        private String cleanServerName(String name) {
            return name.replace("\"", "");
        }

        public String toString() {
            return "Servers{servers=" + this.servers + ", attemptConnectionOrder=" + this.attemptConnectionOrder + "}";
        }
    }
}

