/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.base.Preconditions;
import com.google.common.net.UrlEscapers;
import com.google.common.primitives.Longs;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.VelocityConstants;
import com.velocitypowered.proxy.connection.client.AuthSessionHandler;
import com.velocitypowered.proxy.connection.client.LoginInboundConnection;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import com.velocitypowered.proxy.crypto.IdentifiedKeyImpl;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequest;
import com.velocitypowered.proxy.protocol.packet.EncryptionResponse;
import com.velocitypowered.proxy.protocol.packet.LoginPluginResponse;
import com.velocitypowered.proxy.protocol.packet.ServerLogin;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class InitialLoginSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(InitialLoginSessionHandler.class);
    private static final String MOJANG_HASJOINED_URL = System.getProperty("mojang.sessionserver", "https://sessionserver.mojang.com/session/minecraft/hasJoined").concat("?username=%s&serverId=%s");
    private final VelocityServer server;
    private final MinecraftConnection mcConnection;
    private final LoginInboundConnection inbound;
    private @MonotonicNonNull ServerLogin login;
    private byte[] verify = VelocityConstants.EMPTY_BYTE_ARRAY;
    private LoginState currentState = LoginState.LOGIN_PACKET_EXPECTED;
    private boolean forceKeyAuthentication;

    InitialLoginSessionHandler(VelocityServer server, MinecraftConnection mcConnection, LoginInboundConnection inbound) {
        this.server = Preconditions.checkNotNull(server, "server");
        this.mcConnection = Preconditions.checkNotNull(mcConnection, "mcConnection");
        this.inbound = Preconditions.checkNotNull(inbound, "inbound");
        this.forceKeyAuthentication = System.getProperties().containsKey("auth.forceSecureProfiles") ? Boolean.getBoolean("auth.forceSecureProfiles") : server.getConfiguration().isForceKeyAuthentication();
    }

    @Override
    public boolean handle(ServerLogin packet) {
        this.assertState(LoginState.LOGIN_PACKET_EXPECTED);
        this.currentState = LoginState.LOGIN_PACKET_RECEIVED;
        IdentifiedKey playerKey = packet.getPlayerKey();
        if (playerKey != null) {
            boolean isKeyValid;
            if (playerKey.hasExpired()) {
                this.inbound.disconnect(Component.translatable("multiplayer.disconnect.invalid_public_key_signature"));
                return true;
            }
            if (playerKey.getKeyRevision() == IdentifiedKey.Revision.LINKED_V2 && playerKey instanceof IdentifiedKeyImpl) {
                IdentifiedKeyImpl keyImpl = (IdentifiedKeyImpl)playerKey;
                isKeyValid = keyImpl.internalAddHolder(packet.getHolderUuid());
            } else {
                isKeyValid = playerKey.isSignatureValid();
            }
            if (!isKeyValid) {
                this.inbound.disconnect(Component.translatable("multiplayer.disconnect.invalid_public_key"));
                return true;
            }
        } else if (this.mcConnection.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0 && this.forceKeyAuthentication) {
            this.inbound.disconnect(Component.translatable("multiplayer.disconnect.missing_public_key"));
            return true;
        }
        this.inbound.setPlayerKey(playerKey);
        this.login = packet;
        PreLoginEvent event = new PreLoginEvent(this.inbound, this.login.getUsername());
        ((CompletableFuture)this.server.getEventManager().fire(event).thenRunAsync(() -> {
            if (this.mcConnection.isClosed()) {
                return;
            }
            PreLoginEvent.PreLoginComponentResult result = event.getResult();
            Optional<Component> disconnectReason = result.getReasonComponent();
            if (disconnectReason.isPresent()) {
                this.inbound.disconnect(disconnectReason.get());
                return;
            }
            this.inbound.loginEventFired(() -> {
                if (this.mcConnection.isClosed()) {
                    return;
                }
                this.mcConnection.eventLoop().execute(() -> {
                    if (!result.isForceOfflineMode() && (this.server.getConfiguration().isOnlineMode() || result.isOnlineModeAllowed())) {
                        EncryptionRequest request = this.generateEncryptionRequest();
                        this.verify = Arrays.copyOf(request.getVerifyToken(), 4);
                        this.mcConnection.write(request);
                        this.currentState = LoginState.ENCRYPTION_REQUEST_SENT;
                    } else {
                        this.mcConnection.setSessionHandler(new AuthSessionHandler(this.server, this.inbound, GameProfile.forOfflinePlayer(this.login.getUsername()), false));
                    }
                });
            });
        }, this.mcConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception in pre-login stage", (Throwable)ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(LoginPluginResponse packet) {
        this.inbound.handleLoginPluginResponse(packet);
        return true;
    }

    @Override
    public boolean handle(EncryptionResponse packet) {
        this.assertState(LoginState.ENCRYPTION_REQUEST_SENT);
        this.currentState = LoginState.ENCRYPTION_RESPONSE_RECEIVED;
        ServerLogin login = this.login;
        if (login == null) {
            throw new IllegalStateException("No ServerLogin packet received yet.");
        }
        if (this.verify.length == 0) {
            throw new IllegalStateException("No EncryptionRequest packet sent yet.");
        }
        try {
            KeyPair serverKeyPair = this.server.getServerKeyPair();
            if (this.inbound.getIdentifiedKey() != null) {
                IdentifiedKey playerKey = this.inbound.getIdentifiedKey();
                if (!playerKey.verifyDataSignature(packet.getVerifyToken(), this.verify, Longs.toByteArray(packet.getSalt()))) {
                    throw new IllegalStateException("Invalid client public signature.");
                }
            } else {
                byte[] decryptedVerifyToken = EncryptionUtils.decryptRsa(serverKeyPair, packet.getVerifyToken());
                if (!MessageDigest.isEqual(this.verify, decryptedVerifyToken)) {
                    throw new IllegalStateException("Unable to successfully decrypt the verification token.");
                }
            }
            byte[] decryptedSharedSecret = EncryptionUtils.decryptRsa(serverKeyPair, packet.getSharedSecret());
            String serverId = EncryptionUtils.generateServerId(decryptedSharedSecret, serverKeyPair.getPublic());
            String playerIp = ((InetSocketAddress)this.mcConnection.getRemoteAddress()).getHostString();
            Object url = String.format(MOJANG_HASJOINED_URL, UrlEscapers.urlFormParameterEscaper().escape(login.getUsername()), serverId);
            if (this.server.getConfiguration().shouldPreventClientProxyConnections()) {
                url = (String)url + "&ip=" + UrlEscapers.urlFormParameterEscaper().escape(playerIp);
            }
            ListenableFuture<Response> hasJoinedResponse = this.server.getAsyncHttpClient().prepareGet((String)url).execute();
            hasJoinedResponse.addListener(() -> {
                if (this.mcConnection.isClosed()) {
                    return;
                }
                try {
                    this.mcConnection.enableEncryption(decryptedSharedSecret);
                }
                catch (GeneralSecurityException e) {
                    logger.error("Unable to enable encryption for connection", (Throwable)e);
                    this.mcConnection.close(true);
                    return;
                }
                try {
                    Response profileResponse = (Response)hasJoinedResponse.get();
                    if (profileResponse.getStatusCode() == 200) {
                        IdentifiedKeyImpl key;
                        GameProfile profile = VelocityServer.GENERAL_GSON.fromJson(profileResponse.getResponseBody(), GameProfile.class);
                        if (this.inbound.getIdentifiedKey() != null && this.inbound.getIdentifiedKey().getKeyRevision() == IdentifiedKey.Revision.LINKED_V2 && this.inbound.getIdentifiedKey() instanceof IdentifiedKeyImpl && !(key = (IdentifiedKeyImpl)this.inbound.getIdentifiedKey()).internalAddHolder(profile.getId())) {
                            this.inbound.disconnect(Component.translatable("multiplayer.disconnect.invalid_public_key"));
                        }
                        this.mcConnection.setSessionHandler(new AuthSessionHandler(this.server, this.inbound, profile, true));
                    } else if (profileResponse.getStatusCode() == 204) {
                        this.inbound.disconnect(Component.translatable("velocity.error.online-mode-only", (TextColor)NamedTextColor.RED));
                    } else {
                        logger.error("Got an unexpected error code {} whilst contacting Mojang to log in {} ({})", (Object)profileResponse.getStatusCode(), (Object)login.getUsername(), (Object)playerIp);
                        this.inbound.disconnect(Component.translatable("multiplayer.disconnect.authservers_down"));
                    }
                }
                catch (ExecutionException e) {
                    logger.error("Unable to authenticate with Mojang", (Throwable)e);
                    this.inbound.disconnect(Component.translatable("multiplayer.disconnect.authservers_down"));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }, this.mcConnection.eventLoop());
        }
        catch (GeneralSecurityException e) {
            logger.error("Unable to enable encryption", (Throwable)e);
            this.mcConnection.close(true);
        }
        return true;
    }

    private EncryptionRequest generateEncryptionRequest() {
        byte[] verify = new byte[4];
        ThreadLocalRandom.current().nextBytes(verify);
        EncryptionRequest request = new EncryptionRequest();
        request.setPublicKey(this.server.getServerKeyPair().getPublic().getEncoded());
        request.setVerifyToken(verify);
        return request;
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.mcConnection.close(true);
    }

    @Override
    public void disconnected() {
        this.inbound.cleanup();
    }

    private void assertState(LoginState expectedState) {
        if (this.currentState != expectedState) {
            if (MinecraftDecoder.DEBUG) {
                logger.error("{} Received an unexpected packet requiring state {}, but we are in {}", (Object)this.inbound, (Object)expectedState, (Object)this.currentState);
            }
            this.mcConnection.close(true);
        }
    }

    private static enum LoginState {
        LOGIN_PACKET_EXPECTED,
        LOGIN_PACKET_RECEIVED,
        ENCRYPTION_REQUEST_SENT,
        ENCRYPTION_RESPONSE_RECEIVED;

    }
}

