/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.util;

import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public class ConnectionRequestResults {
    private ConnectionRequestResults() {
        throw new AssertionError();
    }

    public static Impl successful(RegisteredServer server) {
        return ConnectionRequestResults.plainResult(ConnectionRequestBuilder.Status.SUCCESS, server);
    }

    public static Impl plainResult(ConnectionRequestBuilder.Status status, RegisteredServer server) {
        return new Impl(status, null, server, true);
    }

    public static Impl forDisconnect(Component component, RegisteredServer server) {
        return new Impl(ConnectionRequestBuilder.Status.SERVER_DISCONNECTED, component, server, true);
    }

    public static Impl forDisconnect(Disconnect disconnect, RegisteredServer server) {
        Object deserialized = GsonComponentSerializer.gson().deserialize(disconnect.getReason());
        return ConnectionRequestResults.forDisconnect(deserialized, server);
    }

    public static Impl forUnsafeDisconnect(Disconnect disconnect, RegisteredServer server) {
        Object deserialized = GsonComponentSerializer.gson().deserialize(disconnect.getReason());
        return new Impl(ConnectionRequestBuilder.Status.SERVER_DISCONNECTED, (Component)deserialized, server, false);
    }

    public static class Impl
    implements ConnectionRequestBuilder.Result {
        private final ConnectionRequestBuilder.Status status;
        @Nullable
        private final Component component;
        private final RegisteredServer attemptedConnection;
        private final boolean safe;

        Impl(ConnectionRequestBuilder.Status status, @Nullable Component component, RegisteredServer attemptedConnection, boolean safe) {
            this.status = status;
            this.component = component;
            this.attemptedConnection = attemptedConnection;
            this.safe = safe;
        }

        @Override
        public ConnectionRequestBuilder.Status getStatus() {
            return this.status;
        }

        @Override
        public Optional<Component> getReasonComponent() {
            return Optional.ofNullable(this.component);
        }

        @Override
        public RegisteredServer getAttemptedConnection() {
            return this.attemptedConnection;
        }

        public boolean isSafe() {
            return this.safe;
        }
    }
}

