/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.crypto;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.crypto.SignedMessage;
import com.velocitypowered.proxy.crypto.SignaturePair;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SignedChatMessage
implements SignedMessage {
    private static final QuietDecoderException INVALID_SIGNED_CHAT = new QuietDecoderException("Couldn't parse chat message");
    public static final TemporalAmount EXPIRY_TIME = Duration.ofMinutes(2L);
    private final String message;
    private final PublicKey signer;
    private final byte[] signature;
    private final Instant expiry;
    private final byte[] salt;
    private final UUID sender;
    private final SignaturePair[] previousSignatures;
    private final @Nullable SignaturePair previousSignature;
    private final boolean isPreviewSigned;

    public SignedChatMessage(String message, PublicKey signer, UUID sender, Instant expiry, byte[] signature, byte[] salt, boolean isPreviewSigned, @Nullable SignaturePair[] previousSignatures, @Nullable SignaturePair previousSignature) {
        this.message = Preconditions.checkNotNull(message);
        this.signer = Preconditions.checkNotNull(signer);
        this.sender = Preconditions.checkNotNull(sender);
        this.signature = Preconditions.checkNotNull(signature);
        this.expiry = Preconditions.checkNotNull(expiry);
        this.salt = Preconditions.checkNotNull(salt);
        this.isPreviewSigned = isPreviewSigned;
        this.previousSignatures = previousSignatures;
        this.previousSignature = previousSignature;
    }

    @Override
    public PublicKey getSigner() {
        return this.signer;
    }

    @Override
    public Instant getExpiryTemporal() {
        return this.expiry;
    }

    @Override
    public @Nullable byte[] getSignature() {
        return this.signature;
    }

    public SignaturePair[] getPreviousSignatures() {
        return this.previousSignatures;
    }

    public SignaturePair getPreviousSignature() {
        return this.previousSignature;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public UUID getSignerUuid() {
        return this.sender;
    }

    @Override
    public boolean isPreviewSigned() {
        return this.isPreviewSigned;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }
}

