/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.stream.Collectors;

class EventTypeTracker {
    private final Multimap<Class<?>, Class<?>> friends = HashMultimap.create();

    public Collection<Class<?>> getFriendsOf(Class<?> eventType) {
        if (this.friends.containsKey(eventType)) {
            return ImmutableSet.copyOf(this.friends.get(eventType));
        }
        Collection<Class<?>> types = EventTypeTracker.getEventTypes(eventType);
        for (Class<?> type : types) {
            if (type == eventType) continue;
            this.friends.put(type, eventType);
        }
        return types;
    }

    private static Collection<Class<?>> getEventTypes(Class<?> eventType) {
        return TypeToken.of(eventType).getTypes().rawTypes().stream().filter(type -> type != Object.class).collect(Collectors.toList());
    }
}

