/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol;

import com.google.common.collect.Iterables;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.AvailableCommands;
import com.velocitypowered.proxy.protocol.packet.BossBar;
import com.velocitypowered.proxy.protocol.packet.ClientSettings;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequest;
import com.velocitypowered.proxy.protocol.packet.EncryptionResponse;
import com.velocitypowered.proxy.protocol.packet.Handshake;
import com.velocitypowered.proxy.protocol.packet.HeaderAndFooter;
import com.velocitypowered.proxy.protocol.packet.JoinGame;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.LoginPluginMessage;
import com.velocitypowered.proxy.protocol.packet.LoginPluginResponse;
import com.velocitypowered.proxy.protocol.packet.PlayerListItem;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequest;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponse;
import com.velocitypowered.proxy.protocol.packet.Respawn;
import com.velocitypowered.proxy.protocol.packet.ServerData;
import com.velocitypowered.proxy.protocol.packet.ServerLogin;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccess;
import com.velocitypowered.proxy.protocol.packet.SetCompression;
import com.velocitypowered.proxy.protocol.packet.StatusPing;
import com.velocitypowered.proxy.protocol.packet.StatusRequest;
import com.velocitypowered.proxy.protocol.packet.StatusResponse;
import com.velocitypowered.proxy.protocol.packet.TabCompleteRequest;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponse;
import com.velocitypowered.proxy.protocol.packet.chat.LegacyChat;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerChat;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerChatCompletion;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerCommand;
import com.velocitypowered.proxy.protocol.packet.chat.SystemChat;
import com.velocitypowered.proxy.protocol.packet.title.LegacyTitlePacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleActionbarPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleClearPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleSubtitlePacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleTextPacket;
import com.velocitypowered.proxy.protocol.packet.title.TitleTimesPacket;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum StateRegistry {
    HANDSHAKE{
        {
            this.serverbound.register(Handshake.class, Handshake::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
        }
    }
    ,
    STATUS{
        {
            this.serverbound.register(StatusRequest.class, () -> StatusRequest.INSTANCE, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.serverbound.register(StatusPing.class, StatusPing::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(StatusResponse.class, StatusResponse::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(StatusPing.class, StatusPing::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
        }
    }
    ,
    PLAY{
        {
            this.serverbound.fallback = false;
            this.clientbound.fallback = false;
            this.serverbound.register(TabCompleteRequest.class, TabCompleteRequest::new, StateRegistry.map(20, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(6, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(LegacyChat.class, LegacyChat::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_14, ProtocolVersion.MINECRAFT_1_18_2, false));
            this.serverbound.register(PlayerCommand.class, PlayerCommand::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(PlayerChat.class, PlayerChat::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(ClientSettings.class, ClientSettings::new, StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(5, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(8, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(PluginMessage.class, PluginMessage::new, StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(9, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(KeepAlive.class, KeepAlive::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(11, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.serverbound.register(ResourcePackResponse.class, ResourcePackResponse::new, StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_8, false), StateRegistry.map(22, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(29, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(36, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(BossBar.class, BossBar::new, StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(12, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(10, ProtocolVersion.MINECRAFT_1_19, false));
            this.clientbound.register(LegacyChat.class, LegacyChat::new, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_7_2, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_16, true), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_17, ProtocolVersion.MINECRAFT_1_18_2, true));
            this.clientbound.register(TabCompleteResponse.class, TabCompleteResponse::new, StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(14, ProtocolVersion.MINECRAFT_1_19, false));
            this.clientbound.register(AvailableCommands.class, AvailableCommands::new, StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(17, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(18, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(15, ProtocolVersion.MINECRAFT_1_19, false));
            this.clientbound.register(PluginMessage.class, PluginMessage::new, StateRegistry.map(63, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(24, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(22, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(Disconnect.class, Disconnect::new, StateRegistry.map(64, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(27, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(27, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(26, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(23, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(25, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(KeepAlive.class, KeepAlive::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(31, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(33, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(30, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(32, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(JoinGame.class, JoinGame::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(38, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(36, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(38, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(35, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(37, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(Respawn.class, Respawn::new, StateRegistry.map(7, ProtocolVersion.MINECRAFT_1_7_2, true), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_12, true), StateRegistry.map(53, ProtocolVersion.MINECRAFT_1_12_1, true), StateRegistry.map(56, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_14, true), StateRegistry.map(59, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_16, true), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_16_2, true), StateRegistry.map(61, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(59, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(62, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(ResourcePackRequest.class, ResourcePackRequest::new, StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_8, false), StateRegistry.map(50, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_12, false), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(55, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(57, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(56, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(60, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(58, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(61, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(HeaderAndFooter.class, HeaderAndFooter::new, StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_8, true), StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_9_4, true), StateRegistry.map(73, ProtocolVersion.MINECRAFT_1_12, true), StateRegistry.map(74, ProtocolVersion.MINECRAFT_1_12_1, true), StateRegistry.map(78, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(83, ProtocolVersion.MINECRAFT_1_14, true), StateRegistry.map(84, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(83, ProtocolVersion.MINECRAFT_1_16, true), StateRegistry.map(94, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(95, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(96, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(99, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(LegacyTitlePacket.class, LegacyTitlePacket::new, StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_8, true), StateRegistry.map(69, ProtocolVersion.MINECRAFT_1_9, true), StateRegistry.map(71, ProtocolVersion.MINECRAFT_1_12, true), StateRegistry.map(72, ProtocolVersion.MINECRAFT_1_12_1, true), StateRegistry.map(75, ProtocolVersion.MINECRAFT_1_13, true), StateRegistry.map(79, ProtocolVersion.MINECRAFT_1_14, true), StateRegistry.map(80, ProtocolVersion.MINECRAFT_1_15, true), StateRegistry.map(79, ProtocolVersion.MINECRAFT_1_16, ProtocolVersion.MINECRAFT_1_16_4, true));
            this.clientbound.register(TitleSubtitlePacket.class, TitleSubtitlePacket::new, StateRegistry.map(87, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(88, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(91, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(TitleTextPacket.class, TitleTextPacket::new, StateRegistry.map(89, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(90, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(93, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(TitleActionbarPacket.class, TitleActionbarPacket::new, StateRegistry.map(65, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(64, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(67, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(TitleTimesPacket.class, TitleTimesPacket::new, StateRegistry.map(90, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(91, ProtocolVersion.MINECRAFT_1_18, true), StateRegistry.map(94, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(TitleClearPacket.class, TitleClearPacket::new, StateRegistry.map(16, ProtocolVersion.MINECRAFT_1_17, true), StateRegistry.map(13, ProtocolVersion.MINECRAFT_1_19, true));
            this.clientbound.register(PlayerListItem.class, PlayerListItem::new, StateRegistry.map(56, ProtocolVersion.MINECRAFT_1_7_2, false), StateRegistry.map(45, ProtocolVersion.MINECRAFT_1_9, false), StateRegistry.map(46, ProtocolVersion.MINECRAFT_1_12_1, false), StateRegistry.map(48, ProtocolVersion.MINECRAFT_1_13, false), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_14, false), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_15, false), StateRegistry.map(51, ProtocolVersion.MINECRAFT_1_16, false), StateRegistry.map(50, ProtocolVersion.MINECRAFT_1_16_2, false), StateRegistry.map(54, ProtocolVersion.MINECRAFT_1_17, false), StateRegistry.map(52, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(55, ProtocolVersion.MINECRAFT_1_19_1, false));
            this.clientbound.register(SystemChat.class, SystemChat::new, StateRegistry.map(95, ProtocolVersion.MINECRAFT_1_19, true), StateRegistry.map(98, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(PlayerChatCompletion.class, PlayerChatCompletion::new, StateRegistry.map(21, ProtocolVersion.MINECRAFT_1_19_1, true));
            this.clientbound.register(ServerData.class, ServerData::new, StateRegistry.map(63, ProtocolVersion.MINECRAFT_1_19, false), StateRegistry.map(66, ProtocolVersion.MINECRAFT_1_19_1, false));
        }
    }
    ,
    LOGIN{
        {
            this.serverbound.register(ServerLogin.class, ServerLogin::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.serverbound.register(EncryptionResponse.class, EncryptionResponse::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.serverbound.register(LoginPluginResponse.class, LoginPluginResponse::new, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_13, false));
            this.clientbound.register(Disconnect.class, Disconnect::new, StateRegistry.map(0, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(EncryptionRequest.class, EncryptionRequest::new, StateRegistry.map(1, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(ServerLoginSuccess.class, ServerLoginSuccess::new, StateRegistry.map(2, ProtocolVersion.MINECRAFT_1_7_2, false));
            this.clientbound.register(SetCompression.class, SetCompression::new, StateRegistry.map(3, ProtocolVersion.MINECRAFT_1_8, false));
            this.clientbound.register(LoginPluginMessage.class, LoginPluginMessage::new, StateRegistry.map(4, ProtocolVersion.MINECRAFT_1_13, false));
        }
    };

    public static final int STATUS_ID = 1;
    public static final int LOGIN_ID = 2;
    public final PacketRegistry clientbound = new PacketRegistry(ProtocolUtils.Direction.CLIENTBOUND);
    public final PacketRegistry serverbound = new PacketRegistry(ProtocolUtils.Direction.SERVERBOUND);

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private static PacketMapping map(int id, ProtocolVersion version, boolean encodeOnly) {
        return StateRegistry.map(id, version, null, encodeOnly);
    }

    private static PacketMapping map(int id, ProtocolVersion version, ProtocolVersion lastValidProtocolVersion, boolean encodeOnly) {
        return new PacketMapping(id, version, lastValidProtocolVersion, encodeOnly);
    }

    public static final class PacketMapping {
        private final int id;
        private final ProtocolVersion protocolVersion;
        private final boolean encodeOnly;
        private final @Nullable ProtocolVersion lastValidProtocolVersion;

        PacketMapping(int id, ProtocolVersion protocolVersion, ProtocolVersion lastValidProtocolVersion, boolean packetDecoding) {
            this.id = id;
            this.protocolVersion = protocolVersion;
            this.lastValidProtocolVersion = lastValidProtocolVersion;
            this.encodeOnly = packetDecoding;
        }

        public String toString() {
            return "PacketMapping{id=" + this.id + ", protocolVersion=" + this.protocolVersion + ", encodeOnly=" + this.encodeOnly + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PacketMapping that = (PacketMapping)o;
            return this.id == that.id && this.protocolVersion == that.protocolVersion && this.encodeOnly == that.encodeOnly;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.protocolVersion, this.encodeOnly});
        }
    }

    public static class PacketRegistry {
        private final ProtocolUtils.Direction direction;
        private final Map<ProtocolVersion, ProtocolRegistry> versions;
        private boolean fallback = true;

        PacketRegistry(ProtocolUtils.Direction direction) {
            this.direction = direction;
            EnumMap<ProtocolVersion, ProtocolRegistry> mutableVersions = new EnumMap<ProtocolVersion, ProtocolRegistry>(ProtocolVersion.class);
            for (ProtocolVersion version : ProtocolVersion.values()) {
                if (version.isLegacy() || version.isUnknown()) continue;
                mutableVersions.put(version, new ProtocolRegistry(version));
            }
            this.versions = Collections.unmodifiableMap(mutableVersions);
        }

        ProtocolRegistry getProtocolRegistry(ProtocolVersion version) {
            ProtocolRegistry registry = this.versions.get((Object)version);
            if (registry == null) {
                if (this.fallback) {
                    return this.getProtocolRegistry(ProtocolVersion.MINIMUM_VERSION);
                }
                throw new IllegalArgumentException("Could not find data for protocol version " + version);
            }
            return registry;
        }

        <P extends MinecraftPacket> void register(Class<P> clazz, Supplier<P> packetSupplier, PacketMapping ... mappings) {
            if (mappings.length == 0) {
                throw new IllegalArgumentException("At least one mapping must be provided.");
            }
            for (int i = 0; i < mappings.length; ++i) {
                ProtocolVersion protocol;
                ProtocolVersion to;
                PacketMapping current = mappings[i];
                PacketMapping next = i + 1 < mappings.length ? mappings[i + 1] : current;
                ProtocolVersion from = current.protocolVersion;
                ProtocolVersion lastValid = current.lastValidProtocolVersion;
                if (lastValid != null) {
                    if (next != current) {
                        throw new IllegalArgumentException("Cannot add a mapping after last valid mapping");
                    }
                    if (from.compareTo(lastValid) > 0) {
                        throw new IllegalArgumentException("Last mapping version cannot be higher than highest mapping version");
                    }
                }
                ProtocolVersion protocolVersion = current == next ? (lastValid != null ? lastValid : Iterables.getLast(ProtocolVersion.SUPPORTED_VERSIONS)) : (to = next.protocolVersion);
                if (from.compareTo(to) >= 0 && from != Iterables.getLast(ProtocolVersion.SUPPORTED_VERSIONS)) {
                    throw new IllegalArgumentException(String.format("Next mapping version (%s) should be lower then current (%s)", new Object[]{to, from}));
                }
                Iterator iterator = EnumSet.range(from, to).iterator();
                while (iterator.hasNext() && ((protocol = (ProtocolVersion)((Object)iterator.next())) != to || next == current)) {
                    ProtocolRegistry registry = this.versions.get((Object)protocol);
                    if (registry == null) {
                        throw new IllegalArgumentException("Unknown protocol version " + current.protocolVersion);
                    }
                    if (registry.packetIdToSupplier.containsKey(current.id)) {
                        throw new IllegalArgumentException("Can not register class " + clazz.getSimpleName() + " with id " + current.id + " for " + registry.version + " because another packet is already registered");
                    }
                    if (registry.packetClassToId.containsKey(clazz)) {
                        throw new IllegalArgumentException(clazz.getSimpleName() + " is already registered for version " + registry.version);
                    }
                    if (!current.encodeOnly) {
                        registry.packetIdToSupplier.put(current.id, packetSupplier);
                    }
                    registry.packetClassToId.put((Class<? extends MinecraftPacket>)clazz, current.id);
                }
            }
        }

        public class ProtocolRegistry {
            public final ProtocolVersion version;
            final IntObjectMap<Supplier<? extends MinecraftPacket>> packetIdToSupplier = new IntObjectHashMap<Supplier<? extends MinecraftPacket>>(16, 0.5f);
            final Object2IntMap<Class<? extends MinecraftPacket>> packetClassToId = new Object2IntOpenHashMap<Class<? extends MinecraftPacket>>(16, 0.5f);

            ProtocolRegistry(ProtocolVersion version) {
                this.version = version;
                this.packetClassToId.defaultReturnValue(Integer.MIN_VALUE);
            }

            public @Nullable MinecraftPacket createPacket(int id) {
                Supplier<? extends MinecraftPacket> supplier = this.packetIdToSupplier.get(id);
                if (supplier == null) {
                    return null;
                }
                return supplier.get();
            }

            public int getPacketId(MinecraftPacket packet) {
                int id = this.packetClassToId.getInt(packet.getClass());
                if (id == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException(String.format("Unable to find id for packet of type %s in %s protocol %s", new Object[]{packet.getClass().getName(), PacketRegistry.this.direction, this.version}));
                }
                return id;
            }
        }
    }
}

