/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BossBar
implements MinecraftPacket {
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int UPDATE_PERCENT = 2;
    public static final int UPDATE_NAME = 3;
    public static final int UPDATE_STYLE = 4;
    public static final int UPDATE_PROPERTIES = 5;
    private @Nullable UUID uuid;
    private int action;
    private @Nullable String name;
    private float percent;
    private int color;
    private int overlay;
    private short flags;

    public UUID getUuid() {
        if (this.uuid == null) {
            throw new IllegalStateException("No boss bar UUID specified");
        }
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getPercent() {
        return this.percent;
    }

    public void setPercent(float percent) {
        this.percent = percent;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public void setOverlay(int overlay) {
        this.overlay = overlay;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public String toString() {
        return "BossBar{uuid=" + this.uuid + ", action=" + this.action + ", name='" + this.name + "', percent=" + this.percent + ", color=" + this.color + ", overlay=" + this.overlay + ", flags=" + this.flags + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.uuid = ProtocolUtils.readUuid(buf);
        this.action = ProtocolUtils.readVarInt(buf);
        switch (this.action) {
            case 0: {
                this.name = ProtocolUtils.readString(buf);
                this.percent = buf.readFloat();
                this.color = ProtocolUtils.readVarInt(buf);
                this.overlay = ProtocolUtils.readVarInt(buf);
                this.flags = buf.readUnsignedByte();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.percent = buf.readFloat();
                break;
            }
            case 3: {
                this.name = ProtocolUtils.readString(buf);
                break;
            }
            case 4: {
                this.color = ProtocolUtils.readVarInt(buf);
                this.overlay = ProtocolUtils.readVarInt(buf);
                break;
            }
            case 5: {
                this.flags = buf.readUnsignedByte();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown action " + this.action);
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.uuid == null) {
            throw new IllegalStateException("No boss bar UUID specified");
        }
        ProtocolUtils.writeUuid(buf, this.uuid);
        ProtocolUtils.writeVarInt(buf, this.action);
        switch (this.action) {
            case 0: {
                if (this.name == null) {
                    throw new IllegalStateException("No name specified!");
                }
                ProtocolUtils.writeString(buf, this.name);
                buf.writeFloat(this.percent);
                ProtocolUtils.writeVarInt(buf, this.color);
                ProtocolUtils.writeVarInt(buf, this.overlay);
                buf.writeByte(this.flags);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                buf.writeFloat(this.percent);
                break;
            }
            case 3: {
                if (this.name == null) {
                    throw new IllegalStateException("No name specified!");
                }
                ProtocolUtils.writeString(buf, this.name);
                break;
            }
            case 4: {
                ProtocolUtils.writeVarInt(buf, this.color);
                ProtocolUtils.writeVarInt(buf, this.overlay);
                break;
            }
            case 5: {
                buf.writeByte(this.flags);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown action " + this.action);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public static BossBar createRemovePacket(UUID id) {
        BossBar packet = new BossBar();
        packet.setUuid(id);
        packet.setAction(1);
        return packet;
    }
}

