/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.Favicon;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ServerData
implements MinecraftPacket {
    @Nullable
    private Component description;
    @Nullable
    private Favicon favicon;
    private boolean previewsChat;
    private boolean secureChatEnforced;

    public ServerData() {
    }

    public ServerData(@Nullable Component description, @Nullable Favicon favicon, boolean previewsChat, boolean secureChatEnforced) {
        this.description = description;
        this.favicon = favicon;
        this.previewsChat = previewsChat;
        this.secureChatEnforced = secureChatEnforced;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (buf.readBoolean()) {
            this.description = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        }
        if (buf.readBoolean()) {
            this.favicon = new Favicon(ProtocolUtils.readString(buf));
        }
        this.previewsChat = buf.readBoolean();
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            this.secureChatEnforced = buf.readBoolean();
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        boolean hasDescription = this.description != null;
        buf.writeBoolean(hasDescription);
        if (hasDescription) {
            ProtocolUtils.writeString(buf, (CharSequence)ProtocolUtils.getJsonChatSerializer(protocolVersion).serialize(this.description));
        }
        boolean hasFavicon = this.favicon != null;
        buf.writeBoolean(hasFavicon);
        if (hasFavicon) {
            ProtocolUtils.writeString(buf, this.favicon.getBase64Url());
        }
        buf.writeBoolean(this.previewsChat);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            buf.writeBoolean(this.secureChatEnforced);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public Component getDescription() {
        return this.description;
    }

    public Favicon getFavicon() {
        return this.favicon;
    }

    public boolean isPreviewsChat() {
        return this.previewsChat;
    }

    public boolean isSecureChatEnforced() {
        return this.secureChatEnforced;
    }
}

