/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.crypto.SignedChatCommand;
import com.velocitypowered.proxy.crypto.SignedChatMessage;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.LegacyChat;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerChat;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerCommand;
import com.velocitypowered.proxy.protocol.packet.chat.SystemChat;
import java.time.Instant;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class ChatBuilder {
    private final ProtocolVersion version;
    private @MonotonicNonNull Component component;
    private @MonotonicNonNull String message;
    private @MonotonicNonNull SignedChatMessage signedChatMessage;
    private @MonotonicNonNull SignedChatCommand signedCommand;
    private @Nullable Player sender;
    private @Nullable Identity senderIdentity;
    @NotNull
    private Instant timestamp;
    private ChatType type = ChatType.CHAT;

    private ChatBuilder(ProtocolVersion version) {
        this.version = version;
        this.timestamp = Instant.now();
    }

    public static ChatBuilder builder(ProtocolVersion version) {
        return new ChatBuilder(Preconditions.checkNotNull(version));
    }

    public ChatBuilder component(Component message) {
        this.component = Preconditions.checkNotNull(message);
        return this;
    }

    public ChatBuilder message(String message) {
        Preconditions.checkArgument(this.message == null);
        this.message = Preconditions.checkNotNull(message);
        return this;
    }

    public ChatBuilder message(SignedChatMessage message) {
        Preconditions.checkNotNull(message);
        Preconditions.checkArgument(this.message == null);
        this.message = message.getMessage();
        this.signedChatMessage = message;
        return this;
    }

    public ChatBuilder message(SignedChatCommand command) {
        Preconditions.checkNotNull(command);
        Preconditions.checkArgument(this.message == null);
        this.message = command.getBaseCommand();
        this.signedCommand = command;
        return this;
    }

    public ChatBuilder setType(ChatType type) {
        this.type = type;
        return this;
    }

    public ChatBuilder asPlayer(@Nullable Player player) {
        this.sender = player;
        return this;
    }

    public ChatBuilder forIdentity(@Nullable Identity identity) {
        this.senderIdentity = identity;
        return this;
    }

    public ChatBuilder timestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ChatBuilder asServer() {
        this.sender = null;
        return this;
    }

    public MinecraftPacket toClient() {
        Component msg;
        UUID identity = this.sender == null ? (this.senderIdentity == null ? Identity.nil().uuid() : this.senderIdentity.uuid()) : this.sender.getUniqueId();
        Component component = msg = this.component == null ? Component.text(this.message) : this.component;
        if (this.version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            return new SystemChat(msg, this.type == ChatType.CHAT ? ChatType.SYSTEM : this.type);
        }
        return new LegacyChat((String)ProtocolUtils.getJsonChatSerializer(this.version).serialize(msg), this.type.getId(), identity);
    }

    public MinecraftPacket toServer() {
        if (this.version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            if (this.signedChatMessage != null) {
                return new PlayerChat(this.signedChatMessage);
            }
            if (this.signedCommand != null) {
                return new PlayerCommand(this.signedCommand);
            }
            if (this.message.startsWith("/")) {
                return new PlayerCommand(this.message.substring(1), ImmutableList.of(), this.timestamp);
            }
            return new PlayerChat(this.message);
        }
        LegacyChat chat = new LegacyChat();
        chat.setMessage(this.message);
        return chat;
    }

    public static enum ChatType {
        CHAT(0),
        SYSTEM(1),
        GAME_INFO(2);

        private final byte raw;

        private ChatType(byte raw) {
            this.raw = raw;
        }

        public byte getId() {
            return this.raw;
        }
    }
}

