/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class ChatQueue {
    private final Object internalLock;
    private final ConnectedPlayer player;
    private CompletableFuture<WrappedPacket> packetFuture;

    public ChatQueue(ConnectedPlayer player) {
        this.player = player;
        this.packetFuture = CompletableFuture.completedFuture(new WrappedPacket(Instant.EPOCH, null));
        this.internalLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePacket(CompletableFuture<MinecraftPacket> nextPacket, Instant timestamp) {
        Object object = this.internalLock;
        synchronized (object) {
            MinecraftConnection smc = this.player.ensureAndGetCurrentServer().ensureConnected();
            CompletableFuture<WrappedPacket> nextInLine = WrappedPacket.wrap(timestamp, nextPacket);
            ChatQueue.awaitChat(smc, this.packetFuture, nextInLine);
            this.packetFuture = nextInLine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V extends MinecraftPacket> void hijack(K packet, InstantPacketMapper<K, V> instantMapper) {
        Object object = this.internalLock;
        synchronized (object) {
            CompletableFuture<K> trueFuture = CompletableFuture.completedFuture(packet);
            MinecraftConnection smc = this.player.ensureAndGetCurrentServer().ensureConnected();
            this.packetFuture = ChatQueue.hijackCurrentPacket(smc, this.packetFuture, trueFuture, instantMapper);
        }
    }

    private static BiConsumer<WrappedPacket, Throwable> writePacket(MinecraftConnection connection) {
        return (wrappedPacket, throwable) -> {
            if (wrappedPacket != null && !connection.isClosed()) {
                wrappedPacket.write(connection);
            }
        };
    }

    private static <T extends MinecraftPacket> void awaitChat(MinecraftConnection connection, CompletableFuture<WrappedPacket> binder, CompletableFuture<WrappedPacket> future) {
        binder.whenComplete((ignored1, ignored2) -> future.whenComplete((BiConsumer)ChatQueue.writePacket(connection)));
    }

    private static <K, V extends MinecraftPacket> CompletableFuture<WrappedPacket> hijackCurrentPacket(MinecraftConnection connection, CompletableFuture<WrappedPacket> binder, CompletableFuture<K> future, InstantPacketMapper<K, V> packetMapper) {
        CompletableFuture<WrappedPacket> awaitedFuture = new CompletableFuture<WrappedPacket>();
        binder.whenComplete((previous, ignored) -> ((CompletableFuture)WrappedPacket.wrap(previous.timestamp, (CompletableFuture<MinecraftPacket>)future.thenApply(item -> packetMapper.map(previous.timestamp, item))).whenCompleteAsync((BiConsumer)ChatQueue.writePacket(connection), (Executor)connection.eventLoop())).whenComplete((packet, throwable) -> awaitedFuture.complete(throwable != null ? null : packet)));
        return awaitedFuture;
    }

    private static class WrappedPacket {
        private final Instant timestamp;
        private final MinecraftPacket packet;

        private WrappedPacket(Instant timestamp, MinecraftPacket packet) {
            this.timestamp = timestamp;
            this.packet = packet;
        }

        public void write(MinecraftConnection connection) {
            if (this.packet != null) {
                connection.write(this.packet);
            }
        }

        private static CompletableFuture<WrappedPacket> wrap(Instant timestamp, CompletableFuture<MinecraftPacket> nextPacket) {
            return ((CompletableFuture)nextPacket.thenApply(pkt -> new WrappedPacket(timestamp, (MinecraftPacket)pkt))).exceptionally(ignored -> new WrappedPacket(timestamp, null));
        }
    }

    public static interface InstantPacketMapper<K, V extends MinecraftPacket> {
        public V map(Instant var1, K var2);
    }
}

