/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.time.Instant;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerPlayerChat
implements MinecraftPacket {
    private Component component;
    private @Nullable Component unsignedComponent;
    private int type;
    private UUID sender;
    private Component senderName;
    private @Nullable Component teamName;
    private Instant expiry;

    public void setType(int type) {
        this.type = type;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public int getType() {
        return this.type;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.component = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        if (buf.readBoolean()) {
            this.unsignedComponent = this.component = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        }
        this.type = ProtocolUtils.readVarInt(buf);
        this.sender = ProtocolUtils.readUuid(buf);
        this.senderName = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        if (buf.readBoolean()) {
            this.teamName = ProtocolUtils.getJsonChatSerializer(protocolVersion).deserialize(ProtocolUtils.readString(buf));
        }
        this.expiry = Instant.ofEpochMilli(buf.readLong());
        long salt = buf.readLong();
        byte[] signature = ProtocolUtils.readByteArray(buf);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

