/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.tablist;

import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.tablist.VelocityTabList;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityTabListEntry
implements TabListEntry {
    private final VelocityTabList tabList;
    private final GameProfile profile;
    private Component displayName;
    private int latency;
    private int gameMode;
    private @Nullable IdentifiedKey playerKey;

    VelocityTabListEntry(VelocityTabList tabList, GameProfile profile, @Nullable Component displayName, int latency, int gameMode, @Nullable IdentifiedKey playerKey) {
        this.tabList = tabList;
        this.profile = profile;
        this.displayName = displayName;
        this.latency = latency;
        this.gameMode = gameMode;
        this.playerKey = playerKey;
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public Optional<Component> getDisplayNameComponent() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    public TabListEntry setDisplayName(@Nullable Component displayName) {
        this.displayName = displayName;
        this.tabList.updateEntry(3, this);
        return this;
    }

    void setDisplayNameInternal(@Nullable Component displayName) {
        this.displayName = displayName;
    }

    @Override
    public int getLatency() {
        return this.latency;
    }

    @Override
    public TabListEntry setLatency(int latency) {
        this.latency = latency;
        this.tabList.updateEntry(2, this);
        return this;
    }

    void setLatencyInternal(int latency) {
        this.latency = latency;
    }

    @Override
    public int getGameMode() {
        return this.gameMode;
    }

    @Override
    public TabListEntry setGameMode(int gameMode) {
        this.gameMode = gameMode;
        this.tabList.updateEntry(1, this);
        return this;
    }

    void setGameModeInternal(int gameMode) {
        this.gameMode = gameMode;
    }

    @Override
    public IdentifiedKey getIdentifiedKey() {
        return this.playerKey;
    }

    void setPlayerKeyInternal(IdentifiedKey playerKey) {
        this.playerKey = playerKey;
    }
}

