/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.bars.BarState;
import net.torocraft.torohealth.bars.BarStates;
import net.torocraft.torohealth.config.Config;
import net.torocraft.torohealth.util.EntityUtil;

public class HealthBarRenderer {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("torohealth:textures/gui/bars.png");
    private static final int DARK_GRAY = 0x808080;
    private static final float FULL_SIZE = 40.0f;
    private static final List<LivingEntity> renderedEntities = new ArrayList<LivingEntity>();

    private static Config.InWorld getConfig() {
        return ToroHealth.CONFIG.inWorld;
    }

    public static void prepareRenderInWorld(LivingEntity entity) {
        Minecraft client = Minecraft.m_91087_();
        if (!EntityUtil.showHealthBar((Entity)entity, client)) {
            return;
        }
        if (entity.m_20270_(client.m_91288_()) > ToroHealth.CONFIG.inWorld.distance) {
            return;
        }
        BarStates.getState(entity);
        if (Config.Mode.WHEN_HOLDING_WEAPON.equals((Object)HealthBarRenderer.getConfig().mode) && !ToroHealth.IS_HOLDING_WEAPON) {
            return;
        }
        if (Config.Mode.NONE.equals((Object)HealthBarRenderer.getConfig().mode)) {
            return;
        }
        if (ToroHealth.CONFIG.inWorld.onlyWhenLookingAt && ToroHealth.HUD.getEntity() != entity) {
            return;
        }
        if (ToroHealth.CONFIG.inWorld.onlyWhenHurt && entity.m_21223_() >= entity.m_21233_()) {
            return;
        }
        renderedEntities.add(entity);
    }

    public static void renderInWorld(float partialTick, PoseStack matrix, Camera camera) {
        Minecraft client = Minecraft.m_91087_();
        if (camera == null) {
            camera = client.m_91290_().f_114358_;
        }
        if (camera == null) {
            renderedEntities.clear();
            return;
        }
        if (renderedEntities.isEmpty()) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        for (LivingEntity entity : renderedEntities) {
            float scaleToGui = 0.025f;
            boolean sneaking = entity.m_6047_();
            float height = entity.m_20206_() + 0.6f - (sneaking ? 0.25f : 0.0f);
            double x = Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_());
            Vec3 camPos = camera.m_90583_();
            double camX = camPos.m_7096_();
            double camY = camPos.m_7098_();
            double camZ = camPos.m_7094_();
            matrix.m_85836_();
            matrix.m_85837_(x - camX, y + (double)height - camY, z - camZ);
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(-camera.m_90590_()));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
            matrix.m_85841_(-scaleToGui, -scaleToGui, scaleToGui);
            HealthBarRenderer.render(matrix, entity, 0.0, 0.0, 40.0f, true);
            matrix.m_85849_();
        }
        RenderSystem.m_69461_();
        renderedEntities.clear();
    }

    public static void render(PoseStack matrix, LivingEntity entity, double x, double y, float width, boolean inWorld) {
        EntityUtil.Relation relation = EntityUtil.determineRelation((Entity)entity);
        int color = relation.equals((Object)EntityUtil.Relation.FRIEND) ? ToroHealth.CONFIG.bar.friendColor : ToroHealth.CONFIG.bar.foeColor;
        int color2 = relation.equals((Object)EntityUtil.Relation.FRIEND) ? ToroHealth.CONFIG.bar.friendColorSecondary : ToroHealth.CONFIG.bar.foeColorSecondary;
        BarState state = BarStates.getState(entity);
        float percent = Math.min(1.0f, Math.min(state.health, entity.m_21233_()) / entity.m_21233_());
        float percent2 = Math.min(state.previousHealthDisplay, entity.m_21233_()) / entity.m_21233_();
        int zOffset = 0;
        Matrix4f m4f = matrix.m_85850_().m_85861_();
        HealthBarRenderer.drawBar(m4f, x, y, width, 1.0f, 0x808080, zOffset++, inWorld);
        HealthBarRenderer.drawBar(m4f, x, y, width, percent2, color2, zOffset++, inWorld);
        HealthBarRenderer.drawBar(m4f, x, y, width, percent, color, zOffset, inWorld);
        if (!inWorld) {
            if (ToroHealth.CONFIG.bar.damageNumberType.equals((Object)Config.NumberType.CUMULATIVE)) {
                HealthBarRenderer.drawDamageNumber(matrix, state.lastDmgCumulative, x, y, width);
            } else if (ToroHealth.CONFIG.bar.damageNumberType.equals((Object)Config.NumberType.LAST)) {
                HealthBarRenderer.drawDamageNumber(matrix, state.lastDmg, x, y, width);
            }
        }
    }

    public static void drawDamageNumber(PoseStack matrix, int dmg, double x, double y, float width) {
        int i = Math.abs(Math.round(dmg));
        if (i == 0) {
            return;
        }
        String s = Integer.toString(i);
        Minecraft minecraft = Minecraft.m_91087_();
        int sw = minecraft.f_91062_.m_92895_(s);
        int color = dmg < 0 ? ToroHealth.CONFIG.particle.healColor : ToroHealth.CONFIG.particle.damageColor;
        minecraft.f_91062_.m_92883_(matrix, s, (float)((int)(x + (double)(width / 2.0f) - (double)sw)), (float)((int)y + 5), color);
    }

    private static void drawBar(Matrix4f matrix4f, double x, double y, float width, float percent, int color, int zOffset, boolean inWorld) {
        float c = 0.00390625f;
        int u = 0;
        int v = 65;
        int uw = Mth.m_14167_((float)(92.0f * percent));
        int vh = 5;
        double size = percent * width;
        double h = inWorld ? 4.0 : 6.0;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BARS_TEXTURES);
        RenderSystem.m_69478_();
        float half = width / 2.0f;
        float zOffsetAmount = inWorld ? -0.1f : 0.1f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(matrix4f, (float)((double)(-half) + x), (float)y, (float)zOffset * zOffsetAmount).m_7421_((float)u * c, (float)v * c).m_5752_();
        buffer.m_85982_(matrix4f, (float)((double)(-half) + x), (float)(h + y), (float)zOffset * zOffsetAmount).m_7421_((float)u * c, (float)(v + vh) * c).m_5752_();
        buffer.m_85982_(matrix4f, (float)((double)(-half) + size + x), (float)(h + y), (float)zOffset * zOffsetAmount).m_7421_((float)(u + uw) * c, (float)(v + vh) * c).m_5752_();
        buffer.m_85982_(matrix4f, (float)((double)(-half) + size + x), (float)y, (float)zOffset * zOffsetAmount).m_7421_((float)(u + uw) * c, (float)v * c).m_5752_();
        tessellator.m_85914_();
    }
}

