/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.torocraft.torohealth.bars.HealthBarRenderer;

public class BarDisplay {
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("textures/gui/icons.png");
    private final Minecraft mc;
    private final GuiComponent gui;

    public BarDisplay(Minecraft mc, GuiComponent gui) {
        this.mc = mc;
        this.gui = gui;
    }

    private String getEntityName(LivingEntity entity) {
        return entity.m_5446_().getString();
    }

    public void draw(PoseStack matrix, LivingEntity entity) {
        int xOffset = 0;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_TEXTURES);
        RenderSystem.m_69478_();
        HealthBarRenderer.render(matrix, entity, 63.0, 14.0, 130.0f, false);
        String name = this.getEntityName(entity);
        int healthMax = Mth.m_14167_((float)entity.m_21233_());
        int healthCur = Math.min(Mth.m_14167_((float)entity.m_21223_()), healthMax);
        String healthText = healthCur + "/" + healthMax;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93236_((PoseStack)matrix, (Font)this.mc.f_91062_, (String)name, (int)xOffset, (int)2, (int)0xFFFFFF);
        this.mc.f_91062_.m_92750_(matrix, name, (float)xOffset, 2.0f, 0xFFFFFF);
        this.renderHeartIcon(matrix, xOffset += this.mc.f_91062_.m_92895_(name) + 5, 1);
        this.mc.f_91062_.m_92750_(matrix, healthText, (float)(xOffset += 10), 2.0f, 0xE0E0E0);
        xOffset += this.mc.f_91062_.m_92895_(healthText) + 5;
        int armor = entity.m_21230_();
        if (armor > 0) {
            this.renderArmorIcon(matrix, xOffset, 1);
            this.mc.f_91062_.m_92750_(matrix, "" + entity.m_21230_(), (float)(xOffset += 10), 2.0f, 0xE0E0E0);
        }
    }

    private void renderArmorIcon(PoseStack matrix, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_TEXTURES);
        this.gui.m_93228_(matrix, x, y, 34, 9, 9, 9);
    }

    private void renderHeartIcon(PoseStack matrix, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_TEXTURES);
        this.gui.m_93228_(matrix, x, y, 52, 0, 9, 9);
    }
}

