/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;

public class Pairs {
    private final HashMap<String, String> pairs = new HashMap();
    private String lastKey = null;
    private String lastValue = null;

    public void readJson(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            block11: while (reader.peek() != JsonToken.END_OBJECT) {
                switch (reader.nextName()) {
                    case "k": 
                    case "key": {
                        this.setKey(reader.nextString());
                        continue block11;
                    }
                    case "v": 
                    case "value": {
                        this.setValue(reader.nextString());
                        continue block11;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        reader.endArray();
    }

    public void writeJson(JsonWriter writer) throws IOException {
        writer.beginObject();
        writer.endObject();
    }

    public HashMap<String, String> getMap() {
        return this.pairs;
    }

    public void setKey(String key) {
        if (this.lastValue == null) {
            this.lastKey = key;
            return;
        }
        this.pairs.put(key, this.lastValue);
        this.lastValue = null;
        this.lastKey = null;
    }

    public void setValue(String value) {
        if (this.lastKey == null) {
            this.lastValue = value;
            return;
        }
        this.pairs.put(this.lastKey, value);
        this.lastValue = null;
        this.lastKey = null;
    }

    public String getValue(String key) {
        return this.pairs.getOrDefault(key, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.pairs.forEach((key, value) -> sb.append("'").append((String)key).append("'='").append((String)value).append("'").append(","));
        sb.deleteCharAt(sb.length() - 1).append("}");
        return sb.toString();
    }
}

