/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import me.fengming.vaultpatcher_asm.config.DebugMode;

public class VaultPatcherConfig {
    private static final Gson GSON = new Gson();
    public static final DebugMode debug = new DebugMode();
    public static Path config = null;
    public static File configFile = null;
    public static List<String> mods = new ArrayList<String>();
    public static List<String> classes = new ArrayList<String>();
    public static List<String> applyMods = new ArrayList<String>();

    public static List<String> getMods() {
        return mods;
    }

    public static List<String> getClasses() {
        return classes;
    }

    public static List<String> getApplyMods() {
        return applyMods;
    }

    public static DebugMode getDebugMode() {
        return debug;
    }

    private static void writeConfig(JsonWriter jw) throws IOException {
        jw.setIndent("  ");
        jw.beginObject();
        jw.name("mods");
        jw.beginArray();
        mods.forEach(e -> {
            try {
                jw.value(e);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        jw.endArray();
        jw.name("classes");
        jw.beginArray();
        classes.forEach(e -> {
            try {
                jw.value(e);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        jw.endArray();
        jw.name("apply_mods");
        jw.beginArray();
        applyMods.forEach(e -> {
            try {
                jw.value(e);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        jw.endArray();
        jw.name("debug_mode");
        debug.writeJson(jw);
        jw.endObject();
        jw.close();
    }

    public static void save() throws IOException {
        JsonWriter jw = GSON.newJsonWriter((Writer)Files.newBufferedWriter(configFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
        VaultPatcherConfig.writeConfig(jw);
    }

    public static void readConfig(Path path) throws IOException {
        config = path;
        configFile = config.resolve("config.json").toFile();
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            configFile.createNewFile();
            JsonWriter jw = GSON.newJsonWriter((Writer)Files.newBufferedWriter(configFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
            VaultPatcherConfig.writeConfig(jw);
        }
        JsonReader jr = GSON.newJsonReader((Reader)new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        jr.beginObject();
        block16: while (jr.peek() != JsonToken.END_OBJECT) {
            switch (jr.nextName()) {
                case "d": 
                case "debug_mode": {
                    if (jr.peek() != JsonToken.BEGIN_OBJECT) continue block16;
                    debug.readJson(jr);
                    continue block16;
                }
                case "m": 
                case "mods": {
                    if (jr.peek() != JsonToken.BEGIN_ARRAY) continue block16;
                    mods = (List)GSON.fromJson(jr, new TypeToken<List<String>>(){}.getType());
                    continue block16;
                }
                case "c": 
                case "classes": {
                    if (jr.peek() != JsonToken.BEGIN_ARRAY) continue block16;
                    classes = (List)GSON.fromJson(jr, new TypeToken<List<String>>(){}.getType());
                    continue block16;
                }
                case "a": 
                case "apply_mods": {
                    if (jr.peek() != JsonToken.BEGIN_ARRAY) continue block16;
                    applyMods = (List)GSON.fromJson(jr, new TypeToken<List<String>>(){}.getType());
                    continue block16;
                }
            }
            jr.skipValue();
        }
        jr.endObject();
    }
}

