/*
 * Decompiled with CFR 0.152.
 */
package me.fengming.vaultpatcher_asm.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import me.fengming.vaultpatcher_asm.VaultPatcher;
import me.fengming.vaultpatcher_asm.config.Pairs;
import me.fengming.vaultpatcher_asm.config.PatchInfo;
import me.fengming.vaultpatcher_asm.config.TargetClassInfo;
import me.fengming.vaultpatcher_asm.config.TranslationInfo;
import me.fengming.vaultpatcher_asm.config.VaultPatcherConfig;
import me.fengming.vaultpatcher_asm.core.utils.Utils;

public class VaultPatcherPatch {
    private static final Gson GSON = new Gson();
    private final Path patchFile;
    private final List<TranslationInfo> translationInfoList = new ArrayList<TranslationInfo>();
    private boolean dynamic;

    public VaultPatcherPatch(String patchFile) {
        VaultPatcher.debugInfo("[VaultPatcher] Found Module " + patchFile);
        Path p = VaultPatcherConfig.config.resolve(patchFile);
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create", e);
        }
        this.patchFile = p;
    }

    public void read(JsonReader reader) throws IOException {
        reader.beginArray();
        PatchInfo patchInfo = new PatchInfo();
        patchInfo.readJson(reader);
        this.dynamic = patchInfo.isDataDynamic();
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Loading %s!", patchInfo.getInfoName()));
        VaultPatcher.debugInfo("[VaultPatcher] About Information:");
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Author(s): %s", patchInfo.getInfoAuthors()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Mod(s): %s", patchInfo.getInfoMods()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Description: %s", patchInfo.getInfoDesc()));
        VaultPatcher.debugInfo(String.format("[VaultPatcher] Dynamic: %s", patchInfo.isDataDynamic()));
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            ArrayList<TargetClassInfo> targetClassInfos = new ArrayList<TargetClassInfo>();
            TranslationInfo.Mutable mutable = new TranslationInfo.Mutable();
            Pairs pairs = new Pairs();
            block20: while (reader.peek() != JsonToken.END_OBJECT) {
                switch (reader.nextName()) {
                    case "s": 
                    case "target_classes": {
                        TargetClassInfo targetClassInfo;
                        reader.beginArray();
                        while (reader.peek() != JsonToken.END_ARRAY) {
                            targetClassInfo = new TargetClassInfo();
                            targetClassInfo.readJson(reader);
                            targetClassInfos.add(targetClassInfo);
                        }
                        reader.endArray();
                        continue block20;
                    }
                    case "t": 
                    case "target_class": {
                        TargetClassInfo targetClassInfo = new TargetClassInfo();
                        targetClassInfo.readJson(reader);
                        targetClassInfos.add(targetClassInfo);
                        continue block20;
                    }
                    case "k": 
                    case "key": {
                        pairs.setKey(reader.nextString());
                        continue block20;
                    }
                    case "v": 
                    case "value": {
                        pairs.setValue(reader.nextString());
                        continue block20;
                    }
                    case "p": 
                    case "pairs": {
                        pairs.readJson(reader);
                        continue block20;
                    }
                }
                reader.skipValue();
            }
            mutable.setPairs(pairs);
            for (TargetClassInfo targetClassInfo : targetClassInfos) {
                this.translationInfoList.add(mutable.setTargetClassInfo(targetClassInfo));
            }
            reader.endObject();
        }
        reader.endArray();
    }

    public void write(JsonWriter writer) throws IOException {
        writer.setIndent("  ");
        writer.beginArray();
        PatchInfo patchInfo = new PatchInfo();
        patchInfo.writeJson(writer);
        TranslationInfo translationInfo = new TranslationInfo();
        translationInfo.write(writer);
        writer.endArray();
        writer.close();
    }

    public void read() throws IOException {
        Throwable throwable;
        if (Files.notExists(this.patchFile, new LinkOption[0])) {
            Files.createFile(this.patchFile, new FileAttribute[0]);
            throwable = null;
            try (JsonWriter jsonWriter = GSON.newJsonWriter((Writer)Files.newBufferedWriter(this.patchFile, StandardCharsets.UTF_8, new OpenOption[0]));){
                this.write(jsonWriter);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        throwable = null;
        try (JsonReader jsonReader = GSON.newJsonReader((Reader)new InputStreamReader(Files.newInputStream(this.patchFile, new OpenOption[0]), StandardCharsets.UTF_8));){
            this.read(jsonReader);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public List<TranslationInfo> getTranslationInfoList() {
        return this.dynamic ? Utils.EMPTY_LIST : this.translationInfoList;
    }

    public List<TranslationInfo> getDynTranslationInfoList() {
        return this.dynamic ? this.translationInfoList : Utils.EMPTY_LIST;
    }
}

